/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.eventbus.bridge.tcp;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.streams.WriteStream;
import io.vertx.ext.bridge.BridgeOptions;
import io.vertx.ext.bridge.PermittedOptions;
import io.vertx.ext.eventbus.bridge.tcp.BridgeEvent;
import io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge;
import io.vertx.ext.eventbus.bridge.tcp.impl.protocol.FrameHelper;
import io.vertx.ext.eventbus.bridge.tcp.impl.protocol.FrameParser;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class TcpEventBusBridgeTest {
    private Vertx vertx;
    private volatile Handler<BridgeEvent> eventHandler = event -> event.complete((Object)true);

    @Before
    public void before(TestContext context) {
        this.vertx = Vertx.vertx();
        Async async = context.async();
        this.vertx.eventBus().consumer("hello", msg -> msg.reply((Object)new JsonObject().put("value", "Hello " + ((JsonObject)msg.body()).getString("value"))));
        this.vertx.eventBus().consumer("echo", msg -> msg.reply(msg.body()));
        this.vertx.setPeriodic(1000L, __ -> this.vertx.eventBus().send("ping", (Object)new JsonObject().put("value", "hi")));
        TcpEventBusBridge bridge = TcpEventBusBridge.create((Vertx)this.vertx, (BridgeOptions)new BridgeOptions().addInboundPermitted(new PermittedOptions().setAddress("hello")).addInboundPermitted(new PermittedOptions().setAddress("echo")).addInboundPermitted(new PermittedOptions().setAddress("test")).addOutboundPermitted(new PermittedOptions().setAddress("echo")).addOutboundPermitted(new PermittedOptions().setAddress("test")).addOutboundPermitted(new PermittedOptions().setAddress("ping")), (NetServerOptions)new NetServerOptions(), event -> this.eventHandler.handle(event));
        bridge.listen(7000, res -> {
            context.assertTrue(res.succeeded());
            async.complete();
        });
    }

    @After
    public void after(TestContext context) {
        this.vertx.close(context.asyncAssertSuccess());
    }

    @Test
    public void testSendVoidMessage(TestContext context) {
        NetClient client = this.vertx.createNetClient();
        Async async = context.async();
        this.vertx.eventBus().consumer("test", msg -> {
            client.close();
            async.complete();
        });
        client.connect(7000, "localhost", conn -> {
            context.assertFalse(conn.failed());
            NetSocket socket = (NetSocket)conn.result();
            FrameHelper.sendFrame((String)"send", (String)"test", (JsonObject)new JsonObject().put("value", "vert.x"), (WriteStream)socket);
        });
    }

    @Test
    public void testNoHandlers(TestContext context) {
        NetClient client = this.vertx.createNetClient();
        Async async = context.async();
        client.connect(7000, "localhost", conn -> {
            context.assertFalse(conn.failed());
            NetSocket socket = (NetSocket)conn.result();
            FrameParser parser = new FrameParser(parse -> {
                context.assertTrue(parse.succeeded());
                JsonObject frame = (JsonObject)parse.result();
                context.assertEquals((Object)"err", (Object)frame.getString("type"));
                context.assertEquals((Object)"#backtrack", (Object)frame.getString("address"));
                client.close();
                async.complete();
            });
            socket.handler((Handler)parser);
            FrameHelper.sendFrame((String)"send", (String)"test", (String)"#backtrack", (JsonObject)new JsonObject().put("value", "vert.x"), (WriteStream)socket);
        });
    }

    @Test
    public void testErrorReply(TestContext context) {
        NetClient client = this.vertx.createNetClient();
        Async async = context.async();
        this.vertx.eventBus().consumer("test", msg -> msg.fail(0, "oops!"));
        client.connect(7000, "localhost", conn -> {
            context.assertFalse(conn.failed());
            NetSocket socket = (NetSocket)conn.result();
            FrameParser parser = new FrameParser(parse -> {
                context.assertTrue(parse.succeeded());
                JsonObject frame = (JsonObject)parse.result();
                context.assertEquals((Object)"err", (Object)frame.getString("type"));
                context.assertEquals((Object)"#backtrack", (Object)frame.getString("address"));
                client.close();
                async.complete();
            });
            socket.handler((Handler)parser);
            FrameHelper.sendFrame((String)"send", (String)"test", (String)"#backtrack", (JsonObject)new JsonObject().put("value", "vert.x"), (WriteStream)socket);
        });
    }

    @Test
    public void testSendsFromOtherSideOfBridge(TestContext context) {
        NetClient client = this.vertx.createNetClient();
        Async async = context.async();
        client.connect(7000, "localhost", conn -> {
            context.assertFalse(conn.failed());
            NetSocket socket = (NetSocket)conn.result();
            FrameParser parser = new FrameParser(parse -> {
                context.assertTrue(parse.succeeded());
                JsonObject frame = (JsonObject)parse.result();
                context.assertNotEquals((Object)"err", (Object)frame.getString("type"));
                context.assertEquals((Object)true, (Object)frame.getBoolean("send"));
                context.assertEquals((Object)"hi", (Object)frame.getJsonObject("body").getString("value"));
                client.close();
                async.complete();
            });
            socket.handler((Handler)parser);
            FrameHelper.sendFrame((String)"register", (String)"ping", null, (WriteStream)socket);
        });
    }

    @Test
    public void testSendMessageWithReplyBacktrack(TestContext context) {
        NetClient client = this.vertx.createNetClient();
        Async async = context.async();
        client.connect(7000, "localhost", conn -> {
            context.assertFalse(conn.failed());
            NetSocket socket = (NetSocket)conn.result();
            FrameParser parser = new FrameParser(parse -> {
                context.assertTrue(parse.succeeded());
                JsonObject frame = (JsonObject)parse.result();
                context.assertNotEquals((Object)"err", (Object)frame.getString("type"));
                context.assertEquals((Object)true, (Object)frame.getBoolean("send"));
                context.assertEquals((Object)"Hello vert.x", (Object)frame.getJsonObject("body").getString("value"));
                client.close();
                async.complete();
            });
            socket.handler((Handler)parser);
            FrameHelper.sendFrame((String)"send", (String)"hello", (String)"#backtrack", (JsonObject)new JsonObject().put("value", "vert.x"), (WriteStream)socket);
        });
    }

    @Test
    public void testSendMessageWithDuplicateReplyID(TestContext context) {
        NetClient client = this.vertx.createNetClient();
        Async async = context.async();
        client.connect(7000, "localhost", conn -> {
            context.assertFalse(conn.failed());
            NetSocket socket = (NetSocket)conn.result();
            this.vertx.eventBus().consumer("third-party-receiver", msg -> context.fail());
            FrameParser parser = new FrameParser(parse -> {
                context.assertTrue(parse.succeeded());
                client.close();
                async.complete();
            });
            socket.handler((Handler)parser);
            FrameHelper.sendFrame((String)"send", (String)"hello", (String)"third-party-receiver", (JsonObject)new JsonObject().put("value", "vert.x"), (WriteStream)socket);
        });
    }

    @Test
    public void testRegister(TestContext context) {
        NetClient client = this.vertx.createNetClient();
        Async async = context.async();
        client.connect(7000, "localhost", conn -> {
            context.assertFalse(conn.failed());
            NetSocket socket = (NetSocket)conn.result();
            FrameParser parser = new FrameParser(parse -> {
                context.assertTrue(parse.succeeded());
                JsonObject frame = (JsonObject)parse.result();
                context.assertNotEquals((Object)"err", (Object)frame.getString("type"));
                context.assertEquals((Object)false, (Object)frame.getBoolean("send"));
                context.assertEquals((Object)"Vert.x", (Object)frame.getJsonObject("body").getString("value"));
                client.close();
                async.complete();
            });
            socket.handler((Handler)parser);
            FrameHelper.sendFrame((String)"register", (String)"echo", null, (WriteStream)socket);
            FrameHelper.sendFrame((String)"publish", (String)"echo", (JsonObject)new JsonObject().put("value", "Vert.x"), (WriteStream)socket);
        });
    }

    @Test
    public void testUnRegister(TestContext context) {
        NetClient client = this.vertx.createNetClient();
        Async async = context.async();
        String address = "test";
        client.connect(7000, "localhost", conn -> {
            context.assertFalse(conn.failed());
            NetSocket socket = (NetSocket)conn.result();
            AtomicBoolean unregistered = new AtomicBoolean(false);
            FrameParser parser = new FrameParser(parse -> {
                context.assertTrue(parse.succeeded());
                JsonObject frame = (JsonObject)parse.result();
                if (unregistered.get()) {
                    context.assertEquals((Object)"err", (Object)frame.getString("type"));
                    context.assertEquals((Object)"#backtrack", (Object)frame.getString("address"));
                    context.assertEquals((Object)"NO_HANDLERS", (Object)frame.getString("failureType"));
                    context.assertEquals((Object)"No handlers for address test", (Object)frame.getString("message"));
                    client.close();
                    async.complete();
                } else {
                    context.assertNotEquals((Object)"err", (Object)frame.getString("type"));
                    context.assertEquals((Object)false, (Object)frame.getBoolean("send"));
                    context.assertEquals((Object)"Vert.x", (Object)frame.getJsonObject("body").getString("value"));
                    unregistered.compareAndSet(false, true);
                    FrameHelper.sendFrame((String)"unregister", (String)"test", null, (WriteStream)socket);
                    FrameHelper.sendFrame((String)"send", (String)"test", (String)"#backtrack", (JsonObject)new JsonObject().put("value", "This will fail anyway!"), (WriteStream)socket);
                }
            });
            socket.handler((Handler)parser);
            FrameHelper.sendFrame((String)"register", (String)"test", null, (WriteStream)socket);
            FrameHelper.sendFrame((String)"publish", (String)"test", (JsonObject)new JsonObject().put("value", "Vert.x"), (WriteStream)socket);
        });
    }

    @Test
    public void testSendPing(TestContext context) {
        NetClient client = this.vertx.createNetClient();
        Async async = context.async();
        FrameParser parser = new FrameParser(parse -> {
            context.assertTrue(parse.succeeded());
            JsonObject frame = (JsonObject)parse.result();
            context.assertEquals((Object)"pong", (Object)frame.getString("type"));
            client.close();
            async.complete();
        });
        client.connect(7000, "localhost", context.asyncAssertSuccess(socket -> {
            socket.handler((Handler)parser);
            FrameHelper.sendFrame((String)"register", (String)"echo", null, (WriteStream)socket);
            FrameHelper.sendFrame((String)"ping", (WriteStream)socket);
        }));
    }
}

