/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.templ;

import io.vertx.core.AsyncResult;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.ext.web.common.template.TemplateEngine;
import io.vertx.ext.web.templ.mvel.MVELTemplateEngine;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class MVELTemplateNoCacheTest {
    private static Vertx vertx;

    @BeforeClass
    public static void before() {
        vertx = Vertx.vertx((VertxOptions)new VertxOptions().setFileResolverCachingEnabled(false));
    }

    @Test
    public void testCachingDisabled(TestContext should) throws IOException {
        Async test = should.async();
        System.setProperty("vertxweb.environment", "development");
        MVELTemplateEngine engine = MVELTemplateEngine.create((Vertx)vertx);
        File temp = File.createTempFile("template", ".templ", new File("target/classes"));
        temp.deleteOnExit();
        PrintWriter out = new PrintWriter(temp);
        out.print("before");
        out.flush();
        out.close();
        engine.render(new JsonObject(), temp.getParent() + "/" + temp.getName(), arg_0 -> MVELTemplateNoCacheTest.lambda$testCachingDisabled$1(should, temp, (TemplateEngine)engine, test, arg_0));
        test.await();
    }

    private static /* synthetic */ void lambda$testCachingDisabled$1(TestContext should, File temp, TemplateEngine engine, Async test, AsyncResult render) {
        should.assertTrue(render.succeeded());
        should.assertEquals((Object)"before", (Object)((Buffer)render.result()).toString());
        try {
            PrintWriter out2 = new PrintWriter(temp);
            out2.print("after");
            out2.flush();
            out2.close();
        }
        catch (IOException e) {
            should.fail((Throwable)e);
        }
        engine.render(new JsonObject(), temp.getParent() + "/" + temp.getName(), render2 -> {
            should.assertTrue(render2.succeeded());
            should.assertEquals((Object)"after", (Object)((Buffer)render2.result()).toString());
            test.complete();
        });
    }
}

