/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.templ;

import io.vertx.core.AsyncResult;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.ext.web.common.template.TemplateEngine;
import io.vertx.ext.web.templ.mvel.MVELTemplateEngine;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class MVELTemplateTest {
    private static Vertx vertx;

    @BeforeClass
    public static void before() {
        vertx = Vertx.vertx((VertxOptions)new VertxOptions().setFileResolverCachingEnabled(true));
    }

    @Test
    public void testTemplateHandlerOnClasspath(TestContext should) {
        Async test = should.async();
        MVELTemplateEngine engine = MVELTemplateEngine.create((Vertx)vertx);
        JsonObject context = new JsonObject().put("foo", "badger").put("bar", "fox");
        context.put("context", new JsonObject().put("path", "/test-mvel-template2.templ"));
        engine.render(context, "somedir/test-mvel-template2.templ", render -> {
            should.assertTrue(render.succeeded());
            should.assertEquals((Object)"Hello badger and fox\nRequest path is /test-mvel-template2.templ\n", (Object)((Buffer)render.result()).toString());
            test.complete();
        });
        test.await();
    }

    @Test
    public void MVELTemplateTestMVELTemplateTestMVELTemplateTest(TestContext should) {
        Async test = should.async();
        MVELTemplateEngine engine = MVELTemplateEngine.create((Vertx)vertx);
        JsonObject context = new JsonObject().put("foo", "badger").put("bar", "fox");
        context.put("context", new JsonObject().put("path", "/test-mvel-template3.templ"));
        engine.render(context, "src/test/filesystemtemplates/test-mvel-template3.templ", render -> {
            should.assertTrue(render.succeeded());
            should.assertEquals((Object)"Hello badger and fox\nRequest path is /test-mvel-template3.templ\n", (Object)((Buffer)render.result()).toString());
            test.complete();
        });
        test.await();
    }

    @Test
    public void testTemplateHandlerWithInclude(TestContext should) {
        Async test = should.async();
        MVELTemplateEngine engine = MVELTemplateEngine.create((Vertx)vertx);
        JsonObject context = new JsonObject().put("foo", "badger").put("bar", "fox");
        context.put("context", new JsonObject().put("path", "/test-mvel-template4.templ"));
        engine.render(context, "src/test/filesystemtemplates/test-mvel-template4.templ", render -> {
            should.assertTrue(render.succeeded());
            String res = ((Buffer)render.result()).toString();
            should.assertEquals((Object)"Hello badger and fox\n\nRequest path is /test-mvel-template4.templ\n", (Object)res);
            test.complete();
        });
        test.await();
    }

    @Test
    public void testTemplateHandlerOnClasspathDisableCaching(TestContext should) throws Exception {
        System.setProperty("vertxweb.environment", "development");
        this.testTemplateHandlerOnClasspath(should);
    }

    @Test
    public void testTemplateHandlerNoExtension(TestContext should) {
        Async test = should.async();
        MVELTemplateEngine engine = MVELTemplateEngine.create((Vertx)vertx);
        JsonObject context = new JsonObject().put("foo", "badger").put("bar", "fox");
        context.put("context", new JsonObject().put("path", "/test-mvel-template2.templ"));
        engine.render(context, "somedir/test-mvel-template2", render -> {
            should.assertTrue(render.succeeded());
            should.assertEquals((Object)"Hello badger and fox\nRequest path is /test-mvel-template2.templ\n", (Object)((Buffer)render.result()).toString());
            test.complete();
        });
        test.await();
    }

    @Test
    public void testTemplateHandlerChangeExtension(TestContext should) {
        Async test = should.async();
        MVELTemplateEngine engine = MVELTemplateEngine.create((Vertx)vertx).setExtension("bempl");
        JsonObject context = new JsonObject().put("foo", "badger").put("bar", "fox");
        context.put("context", new JsonObject().put("path", "/test-mvel-template2"));
        engine.render(context, "somedir/test-mvel-template2", render -> {
            should.assertTrue(render.succeeded());
            should.assertEquals((Object)"Cheerio badger and fox\nRequest path is /test-mvel-template2\n", (Object)((Buffer)render.result()).toString());
            test.complete();
        });
        test.await();
    }

    @Test
    public void testNoSuchTemplate(TestContext should) {
        Async test = should.async();
        MVELTemplateEngine engine = MVELTemplateEngine.create((Vertx)vertx);
        engine.render(new JsonObject(), "nosuchtemplate.templ", render -> {
            should.assertFalse(render.succeeded());
            test.complete();
        });
        test.await();
    }

    @Test
    public void testCachingEnabled(TestContext should) throws IOException {
        Async test = should.async();
        System.setProperty("vertxweb.environment", "production");
        MVELTemplateEngine engine = MVELTemplateEngine.create((Vertx)vertx);
        File temp = File.createTempFile("template", ".templ", new File("target/classes"));
        temp.deleteOnExit();
        PrintWriter out = new PrintWriter(temp);
        out.print("before");
        out.flush();
        out.close();
        engine.render(new JsonObject(), temp.getParent() + "/" + temp.getName(), arg_0 -> MVELTemplateTest.lambda$testCachingEnabled$7(should, temp, (TemplateEngine)engine, test, arg_0));
        test.await();
    }

    private static /* synthetic */ void lambda$testCachingEnabled$7(TestContext should, File temp, TemplateEngine engine, Async test, AsyncResult render) {
        should.assertTrue(render.succeeded());
        should.assertEquals((Object)"before", (Object)((Buffer)render.result()).toString());
        try {
            PrintWriter out2 = new PrintWriter(temp);
            out2.print("after");
            out2.flush();
            out2.close();
        }
        catch (IOException e) {
            should.fail((Throwable)e);
        }
        engine.render(new JsonObject(), temp.getParent() + "/" + temp.getName(), render2 -> {
            should.assertTrue(render2.succeeded());
            should.assertEquals((Object)"before", (Object)((Buffer)render2.result()).toString());
            test.complete();
        });
    }
}

