/*
 * Decompiled with CFR 0.152.
 */
package io.webdevice.wiring;

import io.webdevice.device.DirectDeviceProvider;
import io.webdevice.util.Collections;
import io.webdevice.wiring.DeviceDefinition;
import io.webdevice.wiring.DeviceDefinitionTest;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;

public class DirectDeviceDefinitionTest
implements DeviceDefinitionTest {
    private DeviceDefinition definition;

    @Before
    public void setUp() {
        this.definition = new DeviceDefinition();
    }

    @Override
    @Test
    public void shouldBuildDefinitionWithoutCapabilitiesAndWithoutConfidential() {
        AbstractBeanDefinition actual = this.definition.withName("myDevice").withDriver(RemoteWebDriver.class).build().getBeanDefinition();
        Assertions.assertThat((Object)actual).isEqualTo((Object)BeanDefinitionBuilder.genericBeanDefinition(DirectDeviceProvider.class).addConstructorArgValue((Object)"myDevice").addConstructorArgValue(RemoteWebDriver.class).setInitMethodName("initialize").setScope("singleton").setRole(2).getBeanDefinition());
    }

    @Override
    @Test
    public void shouldBuildDefinitionWithoutCapabilitiesAndWithConfidential() {
        AbstractBeanDefinition actual = this.definition.withName("myDevice").withDriver(RemoteWebDriver.class).withConfidential("accessKey").build().getBeanDefinition();
        Assertions.assertThat((Object)actual).isEqualTo((Object)BeanDefinitionBuilder.genericBeanDefinition(DirectDeviceProvider.class).addConstructorArgValue((Object)"myDevice").addConstructorArgValue(RemoteWebDriver.class).setInitMethodName("initialize").setScope("singleton").setRole(2).addPropertyValue("confidential", Collections.setOf("accessKey")).getBeanDefinition());
    }

    @Override
    @Test
    public void shouldBuildDefinitionWithCapabilitiesReference() {
        AbstractBeanDefinition actual = this.definition.withName("myDevice").withDriver(RemoteWebDriver.class).withCapabilitiesRef("myDeviceCapabilities").build().getBeanDefinition();
        Assertions.assertThat((Object)actual).isEqualTo((Object)BeanDefinitionBuilder.genericBeanDefinition(DirectDeviceProvider.class).addConstructorArgValue((Object)"myDevice").addConstructorArgValue(RemoteWebDriver.class).setInitMethodName("initialize").setScope("singleton").setRole(2).addPropertyReference("capabilities", "myDeviceCapabilities").getBeanDefinition());
    }

    @Override
    @Test
    public void shouldBuildDefinitionWithOptionsOnly() {
        AbstractBeanDefinition actual = this.definition.withName("myDevice").withDriver(RemoteWebDriver.class).withOptions(MutableCapabilities.class).build().getBeanDefinition();
        Assertions.assertThat((Object)actual).isEqualTo((Object)BeanDefinitionBuilder.genericBeanDefinition(DirectDeviceProvider.class).addConstructorArgValue((Object)"myDevice").addConstructorArgValue(RemoteWebDriver.class).setInitMethodName("initialize").setScope("singleton").setRole(2).addPropertyValue("capabilities", (Object)new MutableCapabilities()).getBeanDefinition());
    }

    @Override
    @Test
    public void shouldBuildDefinitionWithOptionsMergingCapabilities() {
        AbstractBeanDefinition actual = this.definition.withName("myDevice").withDriver(RemoteWebDriver.class).withOptions(MutableCapabilities.class).withCapability("key", (Object)"value").build().getBeanDefinition();
        MutableCapabilities expectedOptions = new MutableCapabilities();
        expectedOptions.setCapability("key", "value");
        Assertions.assertThat((Object)actual).isEqualTo((Object)BeanDefinitionBuilder.genericBeanDefinition(DirectDeviceProvider.class).addConstructorArgValue((Object)"myDevice").addConstructorArgValue(RemoteWebDriver.class).setInitMethodName("initialize").setScope("singleton").setRole(2).addPropertyValue("capabilities", (Object)expectedOptions).getBeanDefinition());
    }

    @Override
    @Test
    public void shouldBuildDefinitionWithOptionsMergingExtraCapabilities() {
        AbstractBeanDefinition actual = this.definition.withName("myDevice").withDriver(RemoteWebDriver.class).withOptions(MutableCapabilities.class).withExtraCapability("sauce:options").withExtraOption("accessKey", (Object)"2secret4u").build().getBeanDefinition();
        MutableCapabilities expectedOptions = new MutableCapabilities();
        expectedOptions.setCapability("sauce:options", (Object)new DesiredCapabilities(Collections.mapOf("accessKey", "2secret4u")));
        Assertions.assertThat((Object)actual).isEqualTo((Object)BeanDefinitionBuilder.genericBeanDefinition(DirectDeviceProvider.class).addConstructorArgValue((Object)"myDevice").addConstructorArgValue(RemoteWebDriver.class).setInitMethodName("initialize").setScope("singleton").setRole(2).addPropertyValue("capabilities", (Object)expectedOptions).getBeanDefinition());
    }

    @Override
    @Test
    public void shouldBuildDefinitionWithOptionsMergingCapabilitiesAndExtraCapabilities() {
        AbstractBeanDefinition actual = this.definition.withName("myDevice").withDriver(RemoteWebDriver.class).withOptions(MutableCapabilities.class).withCapability("key", (Object)"value").withExtraCapability("sauce:options").withExtraOption("accessKey", (Object)"2secret4u").build().getBeanDefinition();
        MutableCapabilities expectedOptions = new MutableCapabilities();
        expectedOptions.setCapability("key", "value");
        expectedOptions.setCapability("sauce:options", (Object)new DesiredCapabilities(Collections.mapOf("accessKey", "2secret4u")));
        Assertions.assertThat((Object)actual).isEqualTo((Object)BeanDefinitionBuilder.genericBeanDefinition(DirectDeviceProvider.class).addConstructorArgValue((Object)"myDevice").addConstructorArgValue(RemoteWebDriver.class).setInitMethodName("initialize").setScope("singleton").setRole(2).addPropertyValue("capabilities", (Object)expectedOptions).getBeanDefinition());
    }

    @Override
    @Test
    public void shouldBuildDefinitionWithDesiredOnly() {
        AbstractBeanDefinition actual = this.definition.withName("myDevice").withDriver(RemoteWebDriver.class).withDesired("iphone").build().getBeanDefinition();
        Assertions.assertThat((Object)actual).isEqualTo((Object)BeanDefinitionBuilder.genericBeanDefinition(DirectDeviceProvider.class).addConstructorArgValue((Object)"myDevice").addConstructorArgValue(RemoteWebDriver.class).setInitMethodName("initialize").setScope("singleton").setRole(2).addPropertyValue("capabilities", (Object)DesiredCapabilities.iphone()).getBeanDefinition());
    }

    @Override
    @Test
    public void shouldBuildDefinitionWithDesiredMergingCapabilities() {
        AbstractBeanDefinition actual = this.definition.withName("myDevice").withDriver(RemoteWebDriver.class).withDesired("iphone").withCapability("key", (Object)"value").build().getBeanDefinition();
        DesiredCapabilities expectedCapabilities = DesiredCapabilities.iphone();
        expectedCapabilities.setCapability("key", "value");
        Assertions.assertThat((Object)actual).isEqualTo((Object)BeanDefinitionBuilder.genericBeanDefinition(DirectDeviceProvider.class).addConstructorArgValue((Object)"myDevice").addConstructorArgValue(RemoteWebDriver.class).setInitMethodName("initialize").setScope("singleton").setRole(2).addPropertyValue("capabilities", (Object)expectedCapabilities).getBeanDefinition());
    }

    @Override
    @Test
    public void shouldBuildDefinitionWithDesiredMergingExtraCapabilities() {
        AbstractBeanDefinition actual = this.definition.withName("myDevice").withDriver(RemoteWebDriver.class).withDesired("iphone").withExtraCapability("sauce:options").withExtraOption("accessKey", (Object)"2secret4u").build().getBeanDefinition();
        DesiredCapabilities expectedCapabilities = DesiredCapabilities.iphone();
        expectedCapabilities.setCapability("sauce:options", (Object)new DesiredCapabilities(Collections.mapOf("accessKey", "2secret4u")));
        Assertions.assertThat((Object)actual).isEqualTo((Object)BeanDefinitionBuilder.genericBeanDefinition(DirectDeviceProvider.class).addConstructorArgValue((Object)"myDevice").addConstructorArgValue(RemoteWebDriver.class).setInitMethodName("initialize").setScope("singleton").setRole(2).addPropertyValue("capabilities", (Object)expectedCapabilities).getBeanDefinition());
    }

    @Override
    @Test
    public void shouldBuildDefinitionWithDesiredMergingCapabilitiesAndExtraCapabilities() {
        AbstractBeanDefinition actual = this.definition.withName("myDevice").withDriver(RemoteWebDriver.class).withDesired("iphone").withCapability("key", (Object)"value").withExtraCapability("sauce:options").withExtraOption("accessKey", (Object)"2secret4u").build().getBeanDefinition();
        DesiredCapabilities expectedCapabilities = DesiredCapabilities.iphone();
        expectedCapabilities.setCapability("key", "value");
        expectedCapabilities.setCapability("sauce:options", (Object)new DesiredCapabilities(Collections.mapOf("accessKey", "2secret4u")));
        Assertions.assertThat((Object)actual).isEqualTo((Object)BeanDefinitionBuilder.genericBeanDefinition(DirectDeviceProvider.class).addConstructorArgValue((Object)"myDevice").addConstructorArgValue(RemoteWebDriver.class).setInitMethodName("initialize").setScope("singleton").setRole(2).addPropertyValue("capabilities", (Object)expectedCapabilities).getBeanDefinition());
    }

    @Override
    @Test
    public void shouldBuildDefinitionWithMapOnly() {
        AbstractBeanDefinition actual = this.definition.withName("myDevice").withDriver(RemoteWebDriver.class).withCapability("key", (Object)"value").build().getBeanDefinition();
        Assertions.assertThat((Object)actual).isEqualTo((Object)BeanDefinitionBuilder.genericBeanDefinition(DirectDeviceProvider.class).addConstructorArgValue((Object)"myDevice").addConstructorArgValue(RemoteWebDriver.class).setInitMethodName("initialize").setScope("singleton").setRole(2).addPropertyValue("capabilities", (Object)new DesiredCapabilities(Collections.mapOf("key", "value"))).getBeanDefinition());
    }

    @Override
    @Test
    public void shouldBuildDefinitionWithMapMergingExtraCapabilities() {
        AbstractBeanDefinition actual = this.definition.withName("myDevice").withDriver(RemoteWebDriver.class).withCapability("key", (Object)"value").withExtraCapability("sauce:options").withExtraOption("accessKey", (Object)"2secret4u").build().getBeanDefinition();
        DesiredCapabilities expectedCapabilities = new DesiredCapabilities(Collections.mapOf("key", "value"));
        expectedCapabilities.setCapability("sauce:options", (Object)new DesiredCapabilities(Collections.mapOf("accessKey", "2secret4u")));
        Assertions.assertThat((Object)actual).isEqualTo((Object)BeanDefinitionBuilder.genericBeanDefinition(DirectDeviceProvider.class).addConstructorArgValue((Object)"myDevice").addConstructorArgValue(RemoteWebDriver.class).setInitMethodName("initialize").setScope("singleton").setRole(2).addPropertyValue("capabilities", (Object)expectedCapabilities).getBeanDefinition());
    }
}

