/*
 * Decompiled with CFR 0.152.
 */
package io.webdevice.wiring;

import io.cucumber.spring.CucumberTestContext;
import io.webdevice.net.MaskingClassLoader;
import io.webdevice.wiring.DeviceDefinition;
import io.webdevice.wiring.Settings;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class SettingsTest {
    private Settings settings;

    @Before
    public void setUp() {
        this.settings = new Settings();
    }

    @Test
    public void shouldStreamDevices() {
        DeviceDefinition iPhone = new DeviceDefinition().withName("iPhone");
        DeviceDefinition iPad = new DeviceDefinition().withName("iPad");
        this.settings.withDevice(iPhone).withDevice(iPad);
        Assertions.assertThat((Stream)this.settings.devices()).contains((Object[])new DeviceDefinition[]{iPhone, iPad});
    }

    @Test
    public void shouldReturnWebDeviceScopeWhenNotSpecifiedAndCucumberNotPresent() throws Exception {
        AtomicReference<Object> scope = new AtomicReference<Object>(null);
        Thread thread = new Thread(() -> scope.set(new Settings().withScope(null).getScope()));
        thread.setContextClassLoader(MaskingClassLoader.classLoaderMasking(CucumberTestContext.class));
        thread.start();
        thread.join();
        Assertions.assertThat((String)scope.get()).isEqualTo("webdevice");
    }

    @Test
    public void shouldReturnCucumberScopeWhenNotSpecifiedAncCucumberPresent() {
        this.settings.withScope(null);
        Assertions.assertThat((String)this.settings.getScope()).isEqualTo("cucumber-glue");
    }

    @Test
    public void shouldReturnScopeWhenSpecified() {
        this.settings.withScope("singleton");
        Assertions.assertThat((String)this.settings.getScope()).isEqualTo("singleton");
    }

    @Test
    public void settingsShouldReturnWebDeviceScopeWhenCucumberNotPresent() throws Exception {
        AtomicReference<Object> scope = new AtomicReference<Object>(null);
        Thread thread = new Thread(() -> scope.set(Settings.scope()));
        thread.setContextClassLoader(MaskingClassLoader.classLoaderMasking(CucumberTestContext.class));
        thread.start();
        thread.join();
        Assertions.assertThat((String)scope.get()).isEqualTo("webdevice");
    }

    @Test
    public void settingsShouldReturnCucumberScopeWhenPresent() {
        Assertions.assertThat((String)Settings.scope()).isEqualTo("cucumber-glue");
    }
}

