/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Map;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ByteArray;
import javassist.bytecode.ConstPool;

public class InnerClassesAttribute
extends AttributeInfo {
    public static final String tag = "InnerClasses";

    InnerClassesAttribute(ConstPool cp, int n, DataInputStream in) throws IOException {
        super(cp, n, in);
    }

    private InnerClassesAttribute(ConstPool cp, byte[] info) {
        super(cp, tag, info);
    }

    public int length() {
        return ByteArray.readU16bit(this.get(), 0);
    }

    public int innerClass(int nth) {
        return ByteArray.readU16bit(this.get(), nth * 8 + 2);
    }

    public int outerClass(int nth) {
        return ByteArray.readU16bit(this.get(), nth * 8 + 4);
    }

    public int innerName(int nth) {
        return ByteArray.readU16bit(this.get(), nth * 8 + 6);
    }

    public int accessFlags(int nth) {
        return ByteArray.readU16bit(this.get(), nth * 8 + 8);
    }

    public AttributeInfo copy(ConstPool newCp, Map classnames) {
        byte[] src = this.get();
        byte[] dest = new byte[src.length];
        ConstPool cp = this.getConstPool();
        InnerClassesAttribute attr = new InnerClassesAttribute(newCp, dest);
        int n = ByteArray.readU16bit(src, 0);
        ByteArray.write16bit(n, dest, 0);
        int j = 2;
        int i = 0;
        while (i < n) {
            int innerClass = ByteArray.readU16bit(src, j);
            int outerClass = ByteArray.readU16bit(src, j + 2);
            int innerName = ByteArray.readU16bit(src, j + 4);
            int innerAccess = ByteArray.readU16bit(src, j + 6);
            if (innerClass != 0) {
                innerClass = cp.copy(innerClass, newCp, classnames);
            }
            ByteArray.write16bit(innerClass, dest, j);
            if (outerClass != 0) {
                outerClass = cp.copy(outerClass, newCp, classnames);
            }
            ByteArray.write16bit(outerClass, dest, j + 2);
            if (innerName != 0) {
                innerName = cp.copy(innerName, newCp, classnames);
            }
            ByteArray.write16bit(innerName, dest, j + 4);
            ByteArray.write16bit(innerAccess, dest, j + 6);
            j += 8;
            ++i;
        }
        return attr;
    }
}

