/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.glide.transformations.gpu;

import androidx.annotation.NonNull;
import java.security.MessageDigest;
import jp.co.cyberagent.android.gpuimage.filter.GPUImageFilter;
import jp.co.cyberagent.android.gpuimage.filter.GPUImageKuwaharaFilter;
import jp.wasabeef.glide.transformations.gpu.GPUFilterTransformation;

public class KuwaharaFilterTransformation
extends GPUFilterTransformation {
    private static final int VERSION = 1;
    private static final String ID = "jp.wasabeef.glide.transformations.gpu.KuwaharaFilterTransformation.1";
    private final int radius;

    public KuwaharaFilterTransformation() {
        this(25);
    }

    public KuwaharaFilterTransformation(int radius) {
        super((GPUImageFilter)new GPUImageKuwaharaFilter());
        this.radius = radius;
        GPUImageKuwaharaFilter filter = (GPUImageKuwaharaFilter)this.getFilter();
        filter.setRadius(this.radius);
    }

    @Override
    public String toString() {
        return "KuwaharaFilterTransformation(radius=" + this.radius + ")";
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof KuwaharaFilterTransformation;
    }

    @Override
    public int hashCode() {
        return ID.hashCode() + this.radius * 10;
    }

    @Override
    public void updateDiskCacheKey(@NonNull MessageDigest messageDigest) {
        messageDigest.update((ID + this.radius).getBytes(CHARSET));
    }
}

