/*
 * Decompiled with CFR 0.152.
 */
package com.mockobjects.jms;

import com.mockobjects.ExpectationCounter;
import com.mockobjects.ExpectationValue;
import com.mockobjects.MockObject;
import java.util.Enumeration;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;

public abstract class MockMessage
extends MockObject
implements Message {
    protected ExpectationCounter myAcknowledgeCount = new ExpectationCounter("MockMessage.acknowledge");
    protected ExpectationValue myJMSReplyTo = new ExpectationValue("MockMessage.setJMSReplyTo");
    protected ExpectationCounter mySetJMSCorrelationIDCalls = new ExpectationCounter("MockMessage.setJMSCorrelationID");
    private JMSException myException;
    private String myJMSMessageID;

    public void acknowledge() throws JMSException {
        this.myAcknowledgeCount.inc();
    }

    public void setExpectedAcknowledgeCalls(int calls) {
        this.myAcknowledgeCount.setExpected(calls);
    }

    public void clearBody() {
        this.notImplemented();
    }

    public void clearProperties() {
        this.notImplemented();
    }

    public boolean getBooleanProperty(String name) {
        this.notImplemented();
        return false;
    }

    public byte getByteProperty(String name) {
        this.notImplemented();
        return 0;
    }

    public double getDoubleProperty(String name) {
        this.notImplemented();
        return 0.0;
    }

    public float getFloatProperty(String name) {
        this.notImplemented();
        return 0.0f;
    }

    public int getIntProperty(String name) {
        this.notImplemented();
        return 0;
    }

    public String getJMSCorrelationID() {
        return this.myJMSMessageID;
    }

    public byte[] getJMSCorrelationIDAsBytes() {
        this.notImplemented();
        return null;
    }

    public int getJMSDeliveryMode() {
        this.notImplemented();
        return 0;
    }

    public Destination getJMSDestination() {
        this.notImplemented();
        return null;
    }

    public long getJMSExpiration() {
        this.notImplemented();
        return 0L;
    }

    public String getJMSMessageID() {
        return this.myJMSMessageID;
    }

    public int getJMSPriority() {
        this.notImplemented();
        return 0;
    }

    public boolean getJMSRedelivered() {
        this.notImplemented();
        return false;
    }

    public Destination getJMSReplyTo() {
        this.notImplemented();
        return null;
    }

    public long getJMSTimestamp() {
        this.notImplemented();
        return 0L;
    }

    public String getJMSType() {
        this.notImplemented();
        return null;
    }

    public long getLongProperty(String name) {
        this.notImplemented();
        return 0L;
    }

    public Object getObjectProperty(String name) {
        this.notImplemented();
        return null;
    }

    public Enumeration getPropertyNames() {
        this.notImplemented();
        return null;
    }

    public short getShortProperty(String name) {
        this.notImplemented();
        return 0;
    }

    public String getStringProperty(String name) {
        this.notImplemented();
        return null;
    }

    public boolean propertyExists(String name) {
        this.notImplemented();
        return false;
    }

    public void setBooleanProperty(String name, boolean value) {
        this.notImplemented();
    }

    public void setByteProperty(String name, byte value) {
        this.notImplemented();
    }

    public void setDoubleProperty(String name, double value) {
        this.notImplemented();
    }

    public void setFloatProperty(String name, float value) {
        this.notImplemented();
    }

    public void setIntProperty(String name, int value) {
        this.notImplemented();
    }

    public void setJMSCorrelationID(String jmsCorrelationID) {
        this.mySetJMSCorrelationIDCalls.inc();
    }

    public void setJMSCorrelationIDAsBytes(byte[] correlationID) {
        this.notImplemented();
    }

    public void setJMSDeliveryMode(int deliveryMode) {
        this.notImplemented();
    }

    public void setJMSDestination(Destination destination) {
        this.notImplemented();
    }

    public void setJMSExpiration(long expiration) {
        this.notImplemented();
    }

    public void setJMSMessageID(String id) {
        this.notImplemented();
    }

    public void setJMSPriority(int priority) {
        this.notImplemented();
    }

    public void setJMSRedelivered(boolean redelivered) {
        this.notImplemented();
    }

    public void setJMSReplyTo(Destination replyTo) throws JMSException {
        this.throwExceptionIfAny();
        this.myJMSReplyTo.setActual((Object)replyTo);
    }

    public void setJMSTimestamp(long timestamp) {
        this.notImplemented();
    }

    public void setJMSType(String type) {
        this.notImplemented();
    }

    public void setLongProperty(String name, long value) {
        this.notImplemented();
    }

    public void setObjectProperty(String name, Object value) {
        this.notImplemented();
    }

    public void setShortProperty(String name, short value) {
        this.notImplemented();
    }

    public void setStringProperty(String name, String value) {
        this.notImplemented();
    }

    public void setExpectedJMSReplyTo(Destination expectedJMSReplyTo) {
        this.myJMSReplyTo.setExpected((Object)expectedJMSReplyTo);
    }

    public void setExpectedSetJMSCorrelationIDCalls(int callCount) {
        this.mySetJMSCorrelationIDCalls.setExpected(callCount);
    }

    public void setupJMSMessageID(String jmsMessageID) {
        this.myJMSMessageID = jmsMessageID;
    }

    public void setupThrowException(JMSException e) {
        this.myException = e;
    }

    protected void throwExceptionIfAny() throws JMSException {
        if (null != this.myException) {
            throw this.myException;
        }
    }
}

