/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.arnx.jsonic.Converter;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.JSONHint;
import net.arnx.jsonic.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CollectionConverter
implements Converter {
    public static final CollectionConverter INSTANCE = new CollectionConverter();

    CollectionConverter() {
    }

    @Override
    public boolean accept(Class<?> clazz) {
        return Collection.class.isAssignableFrom(clazz);
    }

    @Override
    public Object convert(JSON.Context context, Object object, Class<?> clazz, Type type) throws Exception {
        Type type2 = context.getParameterType(type, Collection.class, 0);
        Class<?> clazz2 = ClassUtil.getRawType(type2);
        JSONHint jSONHint = context.getHint();
        Collection collection = null;
        if (object instanceof List) {
            List list = (List)object;
            context.createSizeHint = list.size();
            collection = (Collection)context.createInternal(clazz);
            context.createSizeHint = -1;
            if (Object.class.equals(clazz2)) {
                collection.addAll(list);
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    context.enter(i, jSONHint);
                    collection.add(context.postparseInternal(list.get(i), clazz2, type2));
                    context.exit();
                }
            }
        } else if (object instanceof Map) {
            TreeMap treeMap = (TreeMap)object;
            if (!(treeMap instanceof SortedMap)) {
                treeMap = new TreeMap(treeMap);
            }
            Collection collection2 = treeMap.values();
            context.createSizeHint = collection2.size();
            collection = (Collection)context.createInternal(clazz);
            context.createSizeHint = -1;
            if (Object.class.equals(clazz2)) {
                collection.addAll(collection2);
            } else {
                Iterator iterator = collection2.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    context.enter(n, jSONHint);
                    collection.add(context.postparseInternal(iterator.next(), clazz2, type2));
                    context.exit();
                    ++n;
                }
            }
        } else if (object instanceof Collection) {
            Collection collection3 = (Collection)object;
            context.createSizeHint = collection3.size();
            collection = (Collection)context.createInternal(clazz);
            context.createSizeHint = -1;
            if (Object.class.equals(clazz2)) {
                collection.addAll(collection3);
            } else {
                Iterator iterator = collection3.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    context.enter(n, jSONHint);
                    collection.add(context.postparseInternal(iterator.next(), clazz2, type2));
                    context.exit();
                    ++n;
                }
            }
        } else {
            context.createSizeHint = 1;
            collection = (Collection)context.createInternal(clazz);
            context.createSizeHint = -1;
            if (Object.class.equals(clazz2)) {
                collection.add(object);
            } else {
                context.enter(0, jSONHint);
                collection.add(context.postparseInternal(object, clazz2, type2));
                context.exit();
            }
        }
        return collection;
    }
}

