/*
 * Decompiled with CFR 0.152.
 */
package net.commuty.parking.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.Collection;
import net.commuty.parking.model.UserId;

public class AccessRight {
    private final Collection<UserId> userIds;
    private final String parkingSiteId;
    private final OffsetDateTime startTime;
    private final OffsetDateTime endTime;
    private final boolean granted;

    @JsonCreator
    AccessRight(@JsonProperty(value="userIds") Collection<UserId> userIds, @JsonProperty(value="parkingSiteId") String parkingSiteId, @JsonProperty(value="startTime") OffsetDateTime startTime, @JsonProperty(value="endTime") OffsetDateTime endTime, @JsonProperty(value="granted") boolean granted) {
        this.userIds = userIds;
        this.parkingSiteId = parkingSiteId;
        this.startTime = startTime;
        this.endTime = endTime;
        this.granted = granted;
    }

    @JsonProperty(value="userIds")
    public Collection<UserId> getUserIds() {
        return this.userIds;
    }

    @JsonProperty(value="parkingSiteId")
    public String getParkingSiteId() {
        return this.parkingSiteId;
    }

    @JsonProperty(value="startTime")
    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    @JsonProperty(value="endTime")
    public OffsetDateTime getEndTime() {
        return this.endTime;
    }

    @JsonProperty(value="granted")
    public boolean isGranted() {
        return this.granted;
    }

    public String toString() {
        return "AccessRight{userIds=" + this.userIds + ", parkingSiteId='" + this.parkingSiteId + '\'' + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", granted=" + this.granted + '}';
    }

    public boolean covers(LocalDateTime moment) {
        if (moment == null) {
            throw new IllegalArgumentException("AccessRight.covers: moment must not be null");
        }
        return moment.isBefore(this.endTime.toLocalDateTime()) && !moment.isBefore(this.startTime.toLocalDateTime());
    }

    public boolean startsAfter(LocalDateTime moment) {
        return this.startTime.toLocalDateTime().isAfter(moment);
    }
}

