/*
 * Decompiled with CFR 0.152.
 */
package net.commuty.parking.rest;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import net.commuty.parking.Configuration;
import net.commuty.parking.ParkingAccess;
import net.commuty.parking.http.CredentialsException;
import net.commuty.parking.http.HttpClient;
import net.commuty.parking.http.HttpClientException;
import net.commuty.parking.http.HttpRequestException;
import net.commuty.parking.model.AccessLog;
import net.commuty.parking.model.AccessRight;
import net.commuty.parking.model.Count;
import net.commuty.parking.model.UserId;
import net.commuty.parking.rest.AccessLogRequest;
import net.commuty.parking.rest.AccessLogResponse;
import net.commuty.parking.rest.AccessRightResponse;
import net.commuty.parking.rest.CountRequest;
import net.commuty.parking.rest.JsonMapper;
import net.commuty.parking.rest.MissingUserIdRequest;
import net.commuty.parking.rest.TokenRequest;
import net.commuty.parking.rest.TokenResponse;
import net.commuty.parking.rest.VerificationRequest;
import net.commuty.parking.rest.VerificationResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParkingAccessRestClient
implements ParkingAccess {
    private static final Logger LOG = LoggerFactory.getLogger(ParkingAccessRestClient.class);
    public static final String TOKEN_REQUESTS_URL = "/v2/token-requests";
    public static final String ACCESS_REQUESTS_URL = "/v2/parking-sites/%s/access-requests";
    public static final String ACCESS_RIGHTS_URL = "/v2/access-rights";
    public static final String REPORT_ACCESS_URL = "/v2/parking-sites/%s/access-logs";
    public static final String REPORT_MISSING_IDS_URL = "/v2/missing-user-ids";
    public static final String REPORT_AVAILABLE_SPOTS_COUNT_URL = "/v2/parking-sites/%s/counts";
    public static final String DAY_PARAM = "day";
    public static final String UNREAD_ONLY_PARAM = "unreadOnly";
    private static final int MAX_RETRIES = 5;
    private final Configuration configuration;
    private final HttpClient httpClient;
    private String token;

    public ParkingAccessRestClient(Configuration configuration) {
        this.configuration = configuration;
        this.httpClient = new HttpClient(configuration.getHost(), JsonMapper.create(), configuration.getProxy());
    }

    @Override
    public String authenticate() throws CredentialsException, HttpRequestException, HttpClientException {
        LOG.debug("Authenticating user");
        try {
            TokenResponse auth = this.httpClient.makePostRequest(TOKEN_REQUESTS_URL, null, new TokenRequest(this.configuration.getUsername(), this.configuration.getPassword()), TokenResponse.class);
            this.token = auth.getToken();
            LOG.debug("Authentication done, token saved");
            return this.token;
        }
        catch (HttpRequestException requestException) {
            LOG.warn("Received response code other than 200");
            if (requestException.isForbidden()) {
                LOG.trace("Unable to authenticate: username or password is invalid");
                throw new CredentialsException();
            }
            throw requestException;
        }
    }

    @Override
    public boolean isGranted(String parkingSiteId, UserId user) throws CredentialsException, HttpRequestException, HttpClientException {
        if (parkingSiteId == null || parkingSiteId.trim().isEmpty()) {
            throw new IllegalArgumentException("Parking site cannot be null or blank");
        }
        if (user == null) {
            throw new IllegalArgumentException("UserId cannot be null");
        }
        LOG.debug("Verify whether user {} is authorized to access the parking site {}", (Object)user, (Object)parkingSiteId);
        String path = String.format(ACCESS_REQUESTS_URL, parkingSiteId);
        return this.withRetry(() -> this.httpClient.makePostRequest(path, this.token, new VerificationRequest(user), VerificationResponse.class).isGranted());
    }

    @Override
    public Collection<AccessRight> listAccessRightsForToday() throws CredentialsException, HttpRequestException, HttpClientException {
        return this.listAccessRights(null, null);
    }

    @Override
    public Collection<AccessRight> listAccessRightsForToday(boolean unreadOnly) throws CredentialsException, HttpRequestException, HttpClientException {
        return this.listAccessRights(null, unreadOnly);
    }

    @Override
    public Collection<AccessRight> listAccessRights(LocalDate date, Boolean unreadOnly) throws CredentialsException, HttpRequestException, HttpClientException {
        LOG.debug("Check the presence of Access rights");
        Map<String, String> parameters = this.createListAccessRightQueryParameters(date, unreadOnly);
        return this.withRetry(() -> this.httpClient.makeGetRequest(ACCESS_RIGHTS_URL, this.token, parameters, AccessRightResponse.class).getAccessRights());
    }

    private Map<String, String> createListAccessRightQueryParameters(LocalDate date, Boolean unreadOnly) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (date != null) {
            LOG.debug("Date is set to {}", (Object)date.format(DateTimeFormatter.ISO_LOCAL_DATE));
            parameters.put(DAY_PARAM, date.format(DateTimeFormatter.ISO_LOCAL_DATE));
        }
        if (unreadOnly != null) {
            LOG.debug("unreadOnly is set to {}", (Object)unreadOnly);
            parameters.put(UNREAD_ONLY_PARAM, unreadOnly.toString());
        }
        return parameters;
    }

    @Override
    public String reportAccessLog(String parkingSiteId, Collection<AccessLog> accessLogs) throws CredentialsException, HttpRequestException, HttpClientException {
        if (parkingSiteId == null || parkingSiteId.trim().isEmpty()) {
            throw new IllegalArgumentException("Parking site cannot be null or blank");
        }
        if (accessLogs == null || accessLogs.isEmpty()) {
            throw new IllegalArgumentException("Accesses cannot be null or blank");
        }
        LOG.debug("Report Access logs to Commuty for the site {}", (Object)parkingSiteId);
        String path = String.format(REPORT_ACCESS_URL, parkingSiteId);
        return this.withRetry(() -> this.httpClient.makePostRequest(path, this.token, new AccessLogRequest(accessLogs), AccessLogResponse.class).getLogId());
    }

    @Override
    public UserId reportMissingUserId(UserId user) throws CredentialsException, HttpRequestException, HttpClientException {
        if (user == null) {
            throw new IllegalArgumentException("UserId cannot be null");
        }
        LOG.debug("Report user {} as missing", (Object)user);
        return this.withRetry(() -> this.httpClient.makePostRequest(REPORT_MISSING_IDS_URL, this.token, new MissingUserIdRequest(user), UserId.class));
    }

    @Override
    public Count reportAvailableSpotCount(String parkingSiteId, int count, Integer total) throws CredentialsException, HttpRequestException, HttpClientException {
        if (parkingSiteId == null || parkingSiteId.trim().isEmpty()) {
            throw new IllegalArgumentException("Parking site cannot be null or blank");
        }
        LOG.debug("Report number of available spots to Commuty for the site {}", (Object)parkingSiteId);
        String path = String.format(REPORT_AVAILABLE_SPOTS_COUNT_URL, parkingSiteId);
        return this.withRetry(() -> this.httpClient.makePostRequest(path, this.token, new CountRequest(count, total), Count.class));
    }

    private <T> T withRetry(Callable<T> callable) throws HttpClientException, CredentialsException, HttpRequestException {
        int currentTry = 1;
        while (true) {
            try {
                LOG.trace("Attempt {}/{} to call api", (Object)currentTry, (Object)5);
                this.token = this.token != null ? this.token : this.authenticate();
                return callable.call();
            }
            catch (Exception exception) {
                if (exception instanceof HttpRequestException) {
                    if (!((HttpRequestException)exception).isForbidden()) continue;
                    LOG.trace("Token exception, refreshing token then try again");
                    this.token = this.authenticate();
                    if (++currentTry <= 5) continue;
                    LOG.trace("Maximum attempts reached, throwing underlying exception");
                    throw (HttpRequestException)exception;
                }
                if (exception instanceof CredentialsException) {
                    LOG.trace("Invalid username/password");
                    throw (CredentialsException)exception;
                }
                if (exception instanceof HttpClientException) {
                    LOG.trace("Issue in the client");
                    throw (HttpClientException)exception;
                }
                throw exception instanceof RuntimeException ? (RuntimeException)exception : new RuntimeException(exception);
            }
            break;
        }
    }
}

