/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.field.DecoratedDurationField;
import org.joda.time.field.FieldUtils;

public class ScaledDurationField
extends DecoratedDurationField {
    private static final long serialVersionUID = -3205227092378684157L;
    private final int iScalar;

    public ScaledDurationField(DurationField field, DurationFieldType type, int scalar) {
        super(field, type);
        if (scalar == 0 || scalar == 1) {
            throw new IllegalArgumentException("The scalar must not be 0 or 1");
        }
        this.iScalar = scalar;
    }

    @Override
    public int getValue(long duration) {
        return this.getWrappedField().getValue(duration) / this.iScalar;
    }

    @Override
    public long getValueAsLong(long duration) {
        return this.getWrappedField().getValueAsLong(duration) / (long)this.iScalar;
    }

    @Override
    public int getValue(long duration, long instant) {
        return this.getWrappedField().getValue(duration, instant) / this.iScalar;
    }

    @Override
    public long getValueAsLong(long duration, long instant) {
        return this.getWrappedField().getValueAsLong(duration, instant) / (long)this.iScalar;
    }

    @Override
    public long getMillis(int value) {
        long scaled = (long)value * (long)this.iScalar;
        return this.getWrappedField().getMillis(scaled);
    }

    @Override
    public long getMillis(long value) {
        long scaled = FieldUtils.safeMultiply(value, this.iScalar);
        return this.getWrappedField().getMillis(scaled);
    }

    @Override
    public long getMillis(int value, long instant) {
        long scaled = (long)value * (long)this.iScalar;
        return this.getWrappedField().getMillis(scaled, instant);
    }

    @Override
    public long getMillis(long value, long instant) {
        long scaled = FieldUtils.safeMultiply(value, this.iScalar);
        return this.getWrappedField().getMillis(scaled, instant);
    }

    @Override
    public long add(long instant, int value) {
        long scaled = (long)value * (long)this.iScalar;
        return this.getWrappedField().add(instant, scaled);
    }

    @Override
    public long add(long instant, long value) {
        long scaled = FieldUtils.safeMultiply(value, this.iScalar);
        return this.getWrappedField().add(instant, scaled);
    }

    @Override
    public int getDifference(long minuendInstant, long subtrahendInstant) {
        return this.getWrappedField().getDifference(minuendInstant, subtrahendInstant) / this.iScalar;
    }

    @Override
    public long getDifferenceAsLong(long minuendInstant, long subtrahendInstant) {
        return this.getWrappedField().getDifferenceAsLong(minuendInstant, subtrahendInstant) / (long)this.iScalar;
    }

    @Override
    public long getUnitMillis() {
        return this.getWrappedField().getUnitMillis() * (long)this.iScalar;
    }

    public int getScalar() {
        return this.iScalar;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ScaledDurationField) {
            ScaledDurationField other = (ScaledDurationField)obj;
            return this.getWrappedField().equals(other.getWrappedField()) && this.getType() == other.getType() && this.iScalar == other.iScalar;
        }
        return false;
    }

    public int hashCode() {
        long scalar = this.iScalar;
        int hash = (int)(scalar ^ scalar >>> 32);
        hash += this.getType().hashCode();
        return hash += this.getWrappedField().hashCode();
    }
}

