/*
 * Decompiled with CFR 0.152.
 */
package net.danlew.android.joda;

import android.content.Context;
import android.util.Log;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import net.danlew.android.joda.JodaTimeAndroid;
import net.danlew.android.joda.R;
import net.danlew.android.joda.ResUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.tz.DateTimeZoneBuilder;
import org.joda.time.tz.Provider;

public class ResourceZoneInfoProvider
implements Provider {
    private static Context sAppContext;
    private final Map<String, Object> iZoneInfoMap = ResourceZoneInfoProvider.loadZoneInfoMap(this.openResource("ZoneInfoMap"));

    public static void init(Context context) {
        if (!JodaTimeAndroid.hasInitBeenCalled()) {
            Log.w((String)"joda-time-android", (String)"Calling ResourceZoneInfoProvider.init() directly is deprecated. Use JodaTimeAndroid.init()");
            JodaTimeAndroid.init(context);
        }
        sAppContext = context.getApplicationContext();
    }

    @Override
    public DateTimeZone getZone(String id) {
        if (id == null) {
            return null;
        }
        Object obj = this.iZoneInfoMap.get(id);
        if (obj == null) {
            return null;
        }
        if (id.equals(obj)) {
            return this.loadZoneData(id);
        }
        if (obj instanceof SoftReference) {
            SoftReference ref = (SoftReference)obj;
            DateTimeZone tz = (DateTimeZone)ref.get();
            if (tz != null) {
                return tz;
            }
            return this.loadZoneData(id);
        }
        return this.getZone((String)obj);
    }

    @Override
    public Set<String> getAvailableIDs() {
        return new TreeSet<String>(this.iZoneInfoMap.keySet());
    }

    protected void uncaughtException(Exception ex) {
        ex.printStackTrace();
    }

    private InputStream openResource(String name) throws IOException {
        if (sAppContext == null) {
            throw new RuntimeException("Need to call JodaTimeAndroid.init() before using joda-time-android");
        }
        String resName = ResUtils.getTzResource(name);
        int resId = ResUtils.getIdentifier(R.raw.class, resName);
        if (resId == 0) {
            throw new IOException("Resource not found: \"" + name + "\" (resName: \"" + resName + "\"");
        }
        InputStream in = sAppContext.getResources().openRawResource(resId);
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DateTimeZone loadZoneData(String id) {
        InputStream in = null;
        try {
            in = this.openResource(id);
            DateTimeZone tz = DateTimeZoneBuilder.readFrom(in, id);
            this.iZoneInfoMap.put(id, new SoftReference<DateTimeZone>(tz));
            DateTimeZone dateTimeZone = tz;
            return dateTimeZone;
        }
        catch (IOException ex) {
            this.uncaughtException(ex);
            this.iZoneInfoMap.remove(id);
            DateTimeZone dateTimeZone = null;
            return dateTimeZone;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Object> loadZoneInfoMap(InputStream in) throws IOException {
        ConcurrentHashMap<String, Object> map = new ConcurrentHashMap<String, Object>();
        DataInputStream din = new DataInputStream(in);
        try {
            ResourceZoneInfoProvider.readZoneInfoMap(din, map);
        }
        finally {
            try {
                din.close();
            }
            catch (IOException iOException) {}
        }
        map.put("UTC", new SoftReference<DateTimeZone>(DateTimeZone.UTC));
        return map;
    }

    private static void readZoneInfoMap(DataInputStream din, Map<String, Object> zimap) throws IOException {
        int i;
        int size = din.readUnsignedShort();
        String[] pool = new String[size];
        for (i = 0; i < size; ++i) {
            pool[i] = din.readUTF().intern();
        }
        size = din.readUnsignedShort();
        for (i = 0; i < size; ++i) {
            try {
                zimap.put(pool[din.readUnsignedShort()], pool[din.readUnsignedShort()]);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                throw new IOException("Corrupt zone info map");
            }
        }
    }
}

