/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import org.joda.convert.FromString;
import org.joda.convert.ToString;
import org.joda.time.Chronology;
import org.joda.time.DateTimeUtils;
import org.joda.time.Days;
import org.joda.time.Duration;
import org.joda.time.DurationFieldType;
import org.joda.time.Hours;
import org.joda.time.LocalDate;
import org.joda.time.Minutes;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.Seconds;
import org.joda.time.base.BaseSingleFieldPeriod;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.ISOPeriodFormat;
import org.joda.time.format.PeriodFormatter;

public final class Weeks
extends BaseSingleFieldPeriod {
    public static final Weeks ZERO = new Weeks(0);
    public static final Weeks ONE = new Weeks(1);
    public static final Weeks TWO = new Weeks(2);
    public static final Weeks THREE = new Weeks(3);
    public static final Weeks MAX_VALUE = new Weeks(Integer.MAX_VALUE);
    public static final Weeks MIN_VALUE = new Weeks(Integer.MIN_VALUE);
    private static final PeriodFormatter PARSER = ISOPeriodFormat.standard().withParseType(PeriodType.weeks());
    private static final long serialVersionUID = 87525275727380866L;

    public static Weeks weeks(int weeks) {
        switch (weeks) {
            case 0: {
                return ZERO;
            }
            case 1: {
                return ONE;
            }
            case 2: {
                return TWO;
            }
            case 3: {
                return THREE;
            }
            case 0x7FFFFFFF: {
                return MAX_VALUE;
            }
            case -2147483648: {
                return MIN_VALUE;
            }
        }
        return new Weeks(weeks);
    }

    public static Weeks weeksBetween(ReadableInstant start, ReadableInstant end) {
        int amount = BaseSingleFieldPeriod.between(start, end, DurationFieldType.weeks());
        return Weeks.weeks(amount);
    }

    public static Weeks weeksBetween(ReadablePartial start, ReadablePartial end) {
        if (start instanceof LocalDate && end instanceof LocalDate) {
            Chronology chrono = DateTimeUtils.getChronology(start.getChronology());
            int weeks = chrono.weeks().getDifference(((LocalDate)end).getLocalMillis(), ((LocalDate)start).getLocalMillis());
            return Weeks.weeks(weeks);
        }
        int amount = BaseSingleFieldPeriod.between(start, end, ZERO);
        return Weeks.weeks(amount);
    }

    public static Weeks weeksIn(ReadableInterval interval) {
        if (interval == null) {
            return ZERO;
        }
        int amount = BaseSingleFieldPeriod.between(interval.getStart(), interval.getEnd(), DurationFieldType.weeks());
        return Weeks.weeks(amount);
    }

    public static Weeks standardWeeksIn(ReadablePeriod period) {
        int amount = BaseSingleFieldPeriod.standardPeriodIn(period, 604800000L);
        return Weeks.weeks(amount);
    }

    @FromString
    public static Weeks parseWeeks(String periodStr) {
        if (periodStr == null) {
            return ZERO;
        }
        Period p = PARSER.parsePeriod(periodStr);
        return Weeks.weeks(p.getWeeks());
    }

    private Weeks(int weeks) {
        super(weeks);
    }

    private Object readResolve() {
        return Weeks.weeks(this.getValue());
    }

    @Override
    public DurationFieldType getFieldType() {
        return DurationFieldType.weeks();
    }

    @Override
    public PeriodType getPeriodType() {
        return PeriodType.weeks();
    }

    public Days toStandardDays() {
        return Days.days(FieldUtils.safeMultiply(this.getValue(), 7));
    }

    public Hours toStandardHours() {
        return Hours.hours(FieldUtils.safeMultiply(this.getValue(), 168));
    }

    public Minutes toStandardMinutes() {
        return Minutes.minutes(FieldUtils.safeMultiply(this.getValue(), 10080));
    }

    public Seconds toStandardSeconds() {
        return Seconds.seconds(FieldUtils.safeMultiply(this.getValue(), 604800));
    }

    public Duration toStandardDuration() {
        long weeks = this.getValue();
        return new Duration(weeks * 604800000L);
    }

    public int getWeeks() {
        return this.getValue();
    }

    public Weeks plus(int weeks) {
        if (weeks == 0) {
            return this;
        }
        return Weeks.weeks(FieldUtils.safeAdd(this.getValue(), weeks));
    }

    public Weeks plus(Weeks weeks) {
        if (weeks == null) {
            return this;
        }
        return this.plus(weeks.getValue());
    }

    public Weeks minus(int weeks) {
        return this.plus(FieldUtils.safeNegate(weeks));
    }

    public Weeks minus(Weeks weeks) {
        if (weeks == null) {
            return this;
        }
        return this.minus(weeks.getValue());
    }

    public Weeks multipliedBy(int scalar) {
        return Weeks.weeks(FieldUtils.safeMultiply(this.getValue(), scalar));
    }

    public Weeks dividedBy(int divisor) {
        if (divisor == 1) {
            return this;
        }
        return Weeks.weeks(this.getValue() / divisor);
    }

    public Weeks negated() {
        return Weeks.weeks(FieldUtils.safeNegate(this.getValue()));
    }

    public boolean isGreaterThan(Weeks other) {
        if (other == null) {
            return this.getValue() > 0;
        }
        return this.getValue() > other.getValue();
    }

    public boolean isLessThan(Weeks other) {
        if (other == null) {
            return this.getValue() < 0;
        }
        return this.getValue() < other.getValue();
    }

    @Override
    @ToString
    public String toString() {
        return "P" + String.valueOf(this.getValue()) + "W";
    }
}

