/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.GregorianChronology;
import org.joda.time.field.DecoratedDateTimeField;
import org.joda.time.field.FieldUtils;

class ISOYearOfEraDateTimeField
extends DecoratedDateTimeField {
    private static final long serialVersionUID = 7037524068969447317L;
    static final DateTimeField INSTANCE = new ISOYearOfEraDateTimeField();

    private ISOYearOfEraDateTimeField() {
        super(GregorianChronology.getInstanceUTC().year(), DateTimeFieldType.yearOfEra());
    }

    @Override
    public DurationField getRangeDurationField() {
        return GregorianChronology.getInstanceUTC().eras();
    }

    @Override
    public int get(long instant) {
        int year = this.getWrappedField().get(instant);
        return year < 0 ? -year : year;
    }

    @Override
    public long add(long instant, int years) {
        return this.getWrappedField().add(instant, years);
    }

    @Override
    public long add(long instant, long years) {
        return this.getWrappedField().add(instant, years);
    }

    @Override
    public long addWrapField(long instant, int years) {
        return this.getWrappedField().addWrapField(instant, years);
    }

    @Override
    public int[] addWrapField(ReadablePartial instant, int fieldIndex, int[] values, int years) {
        return this.getWrappedField().addWrapField(instant, fieldIndex, values, years);
    }

    @Override
    public int getDifference(long minuendInstant, long subtrahendInstant) {
        return this.getWrappedField().getDifference(minuendInstant, subtrahendInstant);
    }

    @Override
    public long getDifferenceAsLong(long minuendInstant, long subtrahendInstant) {
        return this.getWrappedField().getDifferenceAsLong(minuendInstant, subtrahendInstant);
    }

    @Override
    public long set(long instant, int year) {
        FieldUtils.verifyValueBounds(this, year, 0, this.getMaximumValue());
        if (this.getWrappedField().get(instant) < 0) {
            year = -year;
        }
        return super.set(instant, year);
    }

    @Override
    public int getMinimumValue() {
        return 0;
    }

    @Override
    public int getMaximumValue() {
        return this.getWrappedField().getMaximumValue();
    }

    @Override
    public long roundFloor(long instant) {
        return this.getWrappedField().roundFloor(instant);
    }

    @Override
    public long roundCeiling(long instant) {
        return this.getWrappedField().roundCeiling(instant);
    }

    @Override
    public long remainder(long instant) {
        return this.getWrappedField().remainder(instant);
    }

    private Object readResolve() {
        return INSTANCE;
    }
}

