/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.util.concurrent.ConcurrentHashMap;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.AssembledChronology;
import org.joda.time.chrono.BasicFixedMonthChronology;
import org.joda.time.chrono.BasicMonthOfYearDateTimeField;
import org.joda.time.chrono.BasicSingleEraDateTimeField;
import org.joda.time.chrono.LimitChronology;
import org.joda.time.chrono.ZonedChronology;
import org.joda.time.field.SkipDateTimeField;

public final class CopticChronology
extends BasicFixedMonthChronology {
    private static final long serialVersionUID = -5972804258688333942L;
    public static final int AM = 1;
    private static final DateTimeField ERA_FIELD = new BasicSingleEraDateTimeField("AM");
    private static final int MIN_YEAR = -292269337;
    private static final int MAX_YEAR = 292272708;
    private static final ConcurrentHashMap<DateTimeZone, CopticChronology[]> cCache = new ConcurrentHashMap();
    private static final CopticChronology INSTANCE_UTC = CopticChronology.getInstance(DateTimeZone.UTC);

    public static CopticChronology getInstanceUTC() {
        return INSTANCE_UTC;
    }

    public static CopticChronology getInstance() {
        return CopticChronology.getInstance(DateTimeZone.getDefault(), 4);
    }

    public static CopticChronology getInstance(DateTimeZone zone) {
        return CopticChronology.getInstance(zone, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CopticChronology getInstance(DateTimeZone zone, int minDaysInFirstWeek) {
        CopticChronology chrono;
        CopticChronology[] oldChronos;
        CopticChronology[] chronos;
        if (zone == null) {
            zone = DateTimeZone.getDefault();
        }
        if ((chronos = cCache.get(zone)) == null && (oldChronos = cCache.putIfAbsent(zone, chronos = new CopticChronology[7])) != null) {
            chronos = oldChronos;
        }
        try {
            chrono = chronos[minDaysInFirstWeek - 1];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid min days in first week: " + minDaysInFirstWeek);
        }
        if (chrono != null) return chrono;
        CopticChronology[] copticChronologyArray = chronos;
        synchronized (chronos) {
            chrono = chronos[minDaysInFirstWeek - 1];
            if (chrono != null) return chrono;
            if (zone == DateTimeZone.UTC) {
                chrono = new CopticChronology(null, null, minDaysInFirstWeek);
                DateTime lowerLimit = new DateTime(1, 1, 1, 0, 0, 0, 0, chrono);
                chrono = new CopticChronology(LimitChronology.getInstance(chrono, lowerLimit, null), null, minDaysInFirstWeek);
            } else {
                chrono = CopticChronology.getInstance(DateTimeZone.UTC, minDaysInFirstWeek);
                chrono = new CopticChronology(ZonedChronology.getInstance(chrono, zone), null, minDaysInFirstWeek);
            }
            chronos[minDaysInFirstWeek - 1] = chrono;
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return chrono;
        }
    }

    CopticChronology(Chronology base, Object param, int minDaysInFirstWeek) {
        super(base, param, minDaysInFirstWeek);
    }

    private Object readResolve() {
        Chronology base = this.getBase();
        int minDays = this.getMinimumDaysInFirstWeek();
        minDays = minDays == 0 ? 4 : minDays;
        return base == null ? CopticChronology.getInstance(DateTimeZone.UTC, minDays) : CopticChronology.getInstance(base.getZone(), minDays);
    }

    @Override
    public Chronology withUTC() {
        return INSTANCE_UTC;
    }

    @Override
    public Chronology withZone(DateTimeZone zone) {
        if (zone == null) {
            zone = DateTimeZone.getDefault();
        }
        if (zone == this.getZone()) {
            return this;
        }
        return CopticChronology.getInstance(zone);
    }

    @Override
    boolean isLeapDay(long instant) {
        return this.dayOfMonth().get(instant) == 6 && this.monthOfYear().isLeap(instant);
    }

    @Override
    long calculateFirstDayOfYearMillis(int year) {
        int leapYears;
        int relativeYear = year - 1687;
        if (relativeYear <= 0) {
            leapYears = relativeYear + 3 >> 2;
        } else {
            leapYears = relativeYear >> 2;
            if (!this.isLeapYear(year)) {
                ++leapYears;
            }
        }
        long millis = ((long)relativeYear * 365L + (long)leapYears) * 86400000L;
        return millis + 21859200000L;
    }

    @Override
    int getMinYear() {
        return -292269337;
    }

    @Override
    int getMaxYear() {
        return 292272708;
    }

    @Override
    long getApproxMillisAtEpochDividedByTwo() {
        return 26607895200000L;
    }

    @Override
    protected void assemble(AssembledChronology.Fields fields) {
        if (this.getBase() == null) {
            super.assemble(fields);
            fields.year = new SkipDateTimeField(this, fields.year);
            fields.weekyear = new SkipDateTimeField(this, fields.weekyear);
            fields.era = ERA_FIELD;
            fields.monthOfYear = new BasicMonthOfYearDateTimeField(this, 13);
            fields.months = fields.monthOfYear.getDurationField();
        }
    }
}

