/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.client.interceptor;

import com.google.common.collect.Lists;
import io.grpc.ClientInterceptor;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import net.devh.boot.grpc.client.interceptor.GlobalClientInterceptorConfigurer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class GlobalClientInterceptorRegistry
implements ApplicationContextAware {
    private final List<ClientInterceptor> clientInterceptors = Lists.newArrayList();
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @PostConstruct
    public void init() {
        Map map = this.applicationContext.getBeansOfType(GlobalClientInterceptorConfigurer.class);
        for (GlobalClientInterceptorConfigurer globalClientInterceptorConfigurer : map.values()) {
            globalClientInterceptorConfigurer.addClientInterceptors(this);
        }
    }

    public GlobalClientInterceptorRegistry addClientInterceptors(ClientInterceptor interceptor) {
        this.clientInterceptors.add(interceptor);
        return this;
    }

    public List<ClientInterceptor> getClientInterceptors() {
        return this.clientInterceptors;
    }
}

