/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.client.nameresolver;

import com.google.common.collect.ImmutableList;
import io.grpc.Attributes;
import io.grpc.EquivalentAddressGroup;
import io.grpc.NameResolver;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class StaticNameResolver
extends NameResolver {
    private final String authority;
    private final List<EquivalentAddressGroup> targets;

    public StaticNameResolver(String authority, EquivalentAddressGroup target) {
        this(authority, (Collection<EquivalentAddressGroup>)ImmutableList.of((Object)Objects.requireNonNull(target, "target")));
    }

    public StaticNameResolver(String authority, Collection<EquivalentAddressGroup> targets) {
        this.authority = Objects.requireNonNull(authority, "authority");
        if (Objects.requireNonNull(targets, "targets").isEmpty()) {
            throw new IllegalArgumentException("Must have at least one target");
        }
        this.targets = ImmutableList.copyOf(targets);
    }

    public String getServiceAuthority() {
        return this.authority;
    }

    public void start(NameResolver.Listener listener) {
        listener.onAddresses(this.targets, Attributes.EMPTY);
    }

    public void refresh() {
    }

    public void shutdown() {
    }

    public String toString() {
        return "StaticNameResolver [authority=" + this.authority + ", targets=" + this.targets + "]";
    }
}

