/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.client.nameresolver;

import io.grpc.Attributes;
import io.grpc.EquivalentAddressGroup;
import io.grpc.NameResolver;
import io.grpc.NameResolverProvider;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.devh.boot.grpc.client.nameresolver.StaticNameResolver;

public class StaticNameResolverProvider
extends NameResolverProvider {
    public static final String STATIC_SCHEME = "static";
    public static final URI STATIC_DEFAULT_URI = URI.create("static://localhost:9090");
    public static final Function<String, URI> STATIC_DEFAULT_URI_MAPPER = clientName -> STATIC_DEFAULT_URI;
    private static final Pattern PATTERN_COMMA = Pattern.compile(",");

    @Nullable
    public NameResolver newNameResolver(URI targetUri, Attributes params) {
        if (STATIC_SCHEME.equals(targetUri.getScheme())) {
            return this.of(targetUri.getAuthority(), params);
        }
        return null;
    }

    private NameResolver of(String targetAuthority, Attributes params) {
        Objects.requireNonNull(targetAuthority, "targetAuthority");
        String[] hosts = PATTERN_COMMA.split(targetAuthority);
        ArrayList<EquivalentAddressGroup> targets = new ArrayList<EquivalentAddressGroup>(hosts.length);
        for (String host : hosts) {
            URI uri = URI.create("//" + host);
            int port = uri.getPort();
            if (port == -1) {
                Integer defaultPort = (Integer)params.get(NameResolver.Factory.PARAMS_DEFAULT_PORT);
                port = defaultPort == null ? 9090 : defaultPort;
            }
            targets.add(new EquivalentAddressGroup((SocketAddress)new InetSocketAddress(uri.getHost(), port)));
        }
        if (targets.isEmpty()) {
            throw new IllegalArgumentException("Must have at least one target, but was: " + targetAuthority);
        }
        return new StaticNameResolver(targetAuthority, targets);
    }

    public String getDefaultScheme() {
        return STATIC_SCHEME;
    }

    protected boolean isAvailable() {
        return true;
    }

    protected int priority() {
        return 5;
    }

    public String toString() {
        return "StaticNameResolverProvider [scheme=" + this.getDefaultScheme() + "]";
    }
}

