/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.common.metric;

import io.grpc.MethodDescriptor;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Timer;
import net.devh.boot.grpc.common.util.GrpcUtils;

public final class MetricUtils {
    public static Counter.Builder prepareCounterFor(MethodDescriptor<?, ?> method, String name, String description) {
        return Counter.builder((String)name).description(description).baseUnit("messages").tag("service", GrpcUtils.extractServiceName(method)).tag("method", GrpcUtils.extractMethodName(method));
    }

    public static Timer.Builder prepareTimerFor(MethodDescriptor<?, ?> method, String name, String description) {
        return Timer.builder((String)name).description(description).tag("service", GrpcUtils.extractServiceName(method)).tag("method", GrpcUtils.extractMethodName(method));
    }

    private MetricUtils() {
    }
}

