/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.interceptor;

import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import java.util.Objects;
import org.springframework.core.Ordered;

public class OrderedServerInterceptor
implements ServerInterceptor,
Ordered {
    private final ServerInterceptor serverInterceptor;
    private final int order;

    public OrderedServerInterceptor(ServerInterceptor serverInterceptor, int order) {
        this.serverInterceptor = Objects.requireNonNull(serverInterceptor, "serverInterceptor");
        this.order = order;
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        return this.serverInterceptor.interceptCall(call, headers, next);
    }

    public int getOrder() {
        return this.order;
    }

    public String toString() {
        return "OrderedServerInterceptor [interceptor=" + this.serverInterceptor + ", order=" + this.order + "]";
    }
}

