/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.apk.parser.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.dongliu.apk.parser.utils.Pair;
import net.dongliu.apk.parser.utils.Utils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ResourceFetcher {
    private void fetchSystemAttrIds() throws IOException, SAXException, ParserConfigurationException {
        String url = "https://android.googlesource.com/platform/frameworks/base/+/master/core/res/res/values/public.xml";
        String html = this.getUrl(url);
        String xml = this.retrieveCode(html);
        if (xml != null) {
            this.parseAttributeXml(xml);
        }
    }

    private void parseAttributeXml(String xml) throws IOException, ParserConfigurationException, SAXException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        final ArrayList attrIds = new ArrayList();
        DefaultHandler dh = new DefaultHandler(){

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if (!qName.equals("public")) {
                    return;
                }
                String type = attributes.getValue("type");
                if (type == null) {
                    return;
                }
                if (type.equals("attr")) {
                    String idStr = attributes.getValue("id");
                    if (idStr == null) {
                        return;
                    }
                    String name = attributes.getValue("name");
                    if (idStr.startsWith("0x")) {
                        idStr = idStr.substring(2);
                    }
                    int id = Integer.parseInt(idStr, 16);
                    attrIds.add(new Pair<Integer, String>(id, name));
                }
            }
        };
        parser.parse((InputStream)new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)), dh);
        for (Pair pair : attrIds) {
            System.out.println(String.format("%s=%d", pair.getRight(), pair.getLeft()));
        }
    }

    private void fetchSystemStyle() throws IOException {
        String[] lines;
        String url = "https://android.googlesource.com/platform/frameworks/base/+/master/api/current.txt";
        String html = this.getUrl(url);
        String code = this.retrieveCode(html);
        int begin = code.indexOf("R.style");
        int end = code.indexOf("}", begin);
        String styleCode = code.substring(begin, end);
        for (String line : lines = styleCode.split("\n")) {
            if (!(line = line.trim()).startsWith("field public static final")) continue;
            line = Utils.substringBefore(line, ";").replace("deprecated ", "").substring("field public static final int ".length()).replace("_", ".");
            System.out.println(line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUrl(String url) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        try {
            conn.setRequestMethod("GET");
            conn.setReadTimeout(10000);
            conn.setConnectTimeout(10000);
            byte[] bytes = Utils.toByteArray(conn.getInputStream());
            String string = new String(bytes, StandardCharsets.UTF_8);
            return string;
        }
        finally {
            conn.disconnect();
        }
    }

    private String retrieveCode(String html) {
        Matcher matcher = Pattern.compile("<ol class=\"prettyprint\">(.*?)</ol>").matcher(html);
        if (matcher.find()) {
            String codeHtml = matcher.group(1);
            return codeHtml.replace("</li>", "\n").replaceAll("<[^>]+>", "").replace("&lt;", "<").replace("&quot;", "\"").replace("&gt;", ">");
        }
        return null;
    }

    public static void main(String[] args) throws ParserConfigurationException, SAXException, IOException {
        ResourceFetcher fetcher = new ResourceFetcher();
        fetcher.fetchSystemAttrIds();
    }
}

