/*
 * Decompiled with CFR 0.152.
 */
package net.hserver.apm.plugin.track;

import java.util.concurrent.atomic.LongAdder;
import javassist.CtClass;
import javassist.CtMethod;
import net.hserver.apm.common.entity.LinkInfo;
import top.hserver.core.interfaces.TrackAdapter;
import top.hserver.core.ioc.annotation.Bean;
import top.hserver.core.queue.HServerQueue;
import top.hserver.core.server.context.ConstConfig;
import top.hserver.core.server.context.HServerContextHolder;
import top.hserver.core.server.context.Webkit;

@Bean
public class ApmTrack
implements TrackAdapter {
    private static final LongAdder ADD = new LongAdder();

    public void track(Class aClass, CtMethod ctMethod, StackTraceElement[] stackTraceElements, long l, long l1, long pSpanId, long spanId) throws Exception {
        Webkit webKit = HServerContextHolder.getWebKit();
        if (webKit != null) {
            LinkInfo linkInfo = new LinkInfo();
            linkInfo.setAppName(ConstConfig.APP_NAME);
            linkInfo.setChainId(webKit.httpRequest.getRequestId());
            linkInfo.setMs(Integer.valueOf((int)(l1 - l)));
            linkInfo.setClassName(aClass.getName());
            linkInfo.setMethod(ctMethod.getName());
            linkInfo.setReturnType(ctMethod.getReturnType().getName());
            linkInfo.setParameterType(this.methodPar(ctMethod));
            linkInfo.setTime(Long.valueOf(System.currentTimeMillis()));
            linkInfo.setPSpanId(String.valueOf(pSpanId));
            linkInfo.setSpanId(String.valueOf(spanId));
            linkInfo.setLevel(String.valueOf(ADD.longValue()));
            ADD.increment();
            HServerQueue.sendQueue((String)"APM_SEND", (Object[])new Object[]{"APM-DATA-LINK-INFO", linkInfo});
        }
    }

    public String methodPar(CtMethod ctMethod) {
        try {
            CtClass[] parameterTypes = ctMethod.getParameterTypes();
            if (parameterTypes == null || parameterTypes.length == 0) {
                return "";
            }
            StringBuilder p = new StringBuilder();
            for (int i = 0; i < parameterTypes.length; ++i) {
                p.append(parameterTypes[i].getName());
                if (i >= parameterTypes.length - 1) continue;
                p.append(",");
            }
            return p.toString();
        }
        catch (Exception e) {
            return "";
        }
    }
}

