package net.hserver.apm.plugin;

import net.hserver.apm.plugin.sql.SqlMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.hserver.core.interfaces.PluginAdapter;
import top.hserver.core.server.util.PropUtil;

public class ApmPlugin implements PluginAdapter {
    private static final Logger log = LoggerFactory.getLogger(ApmPlugin.class);

    @Override
    public void startIocInit() {
        Boolean aBoolean = PropUtil.getInstance().getBoolean("apm.sql");
        if (aBoolean) {
            //处理mysql的驱动拦截
            SqlMonitor.modify();
        }
    }

    @Override
    public void iocInitEnd() {

    }

    @Override
    public void startInjection() {

    }

    @Override
    public void injectionEnd() {
        log.debug("APM插件加载");
    }

}
