package net.hserver.apm.plugin.queue;

import net.hserver.apm.common.DataConfig;
import top.hserver.core.ioc.annotation.queue.QueueHandler;
import top.hserver.core.ioc.annotation.queue.QueueListener;
import top.hserver.core.queue.HServerQueue;
import top.hserver.core.server.context.ConstConfig;
import top.hserver.core.server.context.HumMessage;

import static net.hserver.apm.common.DataConfig.APM_DATA_INFO;

@QueueListener(queueName = "APM_SEND")
public class SendQueue {

    @QueueHandler(sizePropValue = "apm.size",size = 8)
    public void send(String type, Object data) {
        try {
            if (type.equals(APM_DATA_INFO) || type.equals(DataConfig.APM_DATA_LOG_INFO) || type.equals(DataConfig.APM_DATA_REQUEST_INFO)||type.equals(DataConfig.APM_DATA_LINK_INFO)||type.equals(DataConfig.APM_DATA_SQL_INFO)) {
                if (DataConfig.hum != null && DataConfig.hum.isLive()) {
                    DataConfig.hum.sendMessage(new HumMessage(type, ConstConfig.JSON.writeValueAsString(data)));
                } else {
                    //休息一秒
                    Thread.sleep(1000);
                }
            }
        } catch (Exception e) {
        }
    }

}
