/*
 * Decompiled with CFR 0.152.
 */
package net.jsign;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import net.jsign.asn1.authenticode.AuthenticodeObjectIdentifiers;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;

public class SignatureUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<CMSSignedData> getSignatures(byte[] signature) throws IOException {
        try (ASN1InputStream in = new ASN1InputStream(signature);){
            CMSSignedData signedData = new CMSSignedData((CMSProcessable)null, ContentInfo.getInstance((Object)in.readObject()));
            List<CMSSignedData> list = SignatureUtils.getSignatures(signedData);
            return list;
        }
        catch (ClassCastException | IllegalArgumentException | IllegalStateException | StackOverflowError | NoSuchElementException | CMSException e) {
            throw new IOException(e);
        }
    }

    public static List<CMSSignedData> getSignatures(CMSSignedData signature) throws IOException {
        ArrayList<CMSSignedData> signatures = new ArrayList<CMSSignedData>();
        try {
            if (signature != null) {
                Attribute nestedSignatures;
                signatures.add(signature);
                SignerInformation signerInformation = (SignerInformation)signature.getSignerInfos().iterator().next();
                AttributeTable unsignedAttributes = signerInformation.getUnsignedAttributes();
                if (unsignedAttributes != null && (nestedSignatures = unsignedAttributes.get(AuthenticodeObjectIdentifiers.SPC_NESTED_SIGNATURE_OBJID)) != null) {
                    for (ASN1Encodable nestedSignature : nestedSignatures.getAttrValues()) {
                        signatures.add(new CMSSignedData((CMSProcessable)null, ContentInfo.getInstance((Object)nestedSignature)));
                    }
                }
            }
        }
        catch (CMSException e) {
            throw new IOException(e);
        }
        return signatures;
    }

    static CMSSignedData addNestedSignature(CMSSignedData parent, boolean replace, CMSSignedData ... children) {
        SignerInformation signerInformation = (SignerInformation)parent.getSignerInfos().iterator().next();
        AttributeTable unsignedAttributes = signerInformation.getUnsignedAttributes();
        if (unsignedAttributes == null) {
            unsignedAttributes = new AttributeTable((ASN1Set)new DERSet());
        }
        Attribute nestedSignaturesAttribute = unsignedAttributes.get(AuthenticodeObjectIdentifiers.SPC_NESTED_SIGNATURE_OBJID);
        ASN1EncodableVector nestedSignatures = new ASN1EncodableVector();
        if (nestedSignaturesAttribute != null && !replace) {
            for (ASN1Encodable nestedSignature : nestedSignaturesAttribute.getAttrValues()) {
                nestedSignatures.add(nestedSignature);
            }
        }
        for (CMSSignedData nestedSignature : children) {
            nestedSignatures.add((ASN1Encodable)nestedSignature.toASN1Structure());
        }
        ASN1EncodableVector attributes = unsignedAttributes.remove(AuthenticodeObjectIdentifiers.SPC_NESTED_SIGNATURE_OBJID).toASN1EncodableVector();
        attributes.add((ASN1Encodable)new Attribute(AuthenticodeObjectIdentifiers.SPC_NESTED_SIGNATURE_OBJID, (ASN1Set)new DERSet(nestedSignatures)));
        unsignedAttributes = new AttributeTable(attributes);
        signerInformation = SignerInformation.replaceUnsignedAttributes((SignerInformation)signerInformation, (AttributeTable)unsignedAttributes);
        return CMSSignedData.replaceSigners((CMSSignedData)parent, (SignerInformationStore)new SignerInformationStore(signerInformation));
    }

    static boolean isTimestamped(CMSSignedData signature) {
        SignerInformation signerInformation = (SignerInformation)signature.getSignerInfos().iterator().next();
        AttributeTable unsignedAttributes = signerInformation.getUnsignedAttributes();
        if (unsignedAttributes == null) {
            return false;
        }
        boolean authenticode = AuthenticodeObjectIdentifiers.isAuthenticode(signature.getSignedContentTypeOID());
        Attribute authenticodeTimestampAttribute = unsignedAttributes.get(CMSAttributes.counterSignature);
        Attribute rfc3161TimestampAttribute = unsignedAttributes.get(authenticode ? AuthenticodeObjectIdentifiers.SPC_RFC3161_OBJID : PKCSObjectIdentifiers.id_aa_signatureTimeStampToken);
        return authenticodeTimestampAttribute != null || rfc3161TimestampAttribute != null;
    }

    static CMSSignedData removeTimestamp(CMSSignedData signature) {
        SignerInformation signerInformation = (SignerInformation)signature.getSignerInfos().iterator().next();
        AttributeTable unsignedAttributes = signerInformation.getUnsignedAttributes();
        if (unsignedAttributes == null) {
            return signature;
        }
        unsignedAttributes = unsignedAttributes.remove(CMSAttributes.counterSignature);
        unsignedAttributes = unsignedAttributes.remove(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken);
        unsignedAttributes = unsignedAttributes.remove(AuthenticodeObjectIdentifiers.SPC_RFC3161_OBJID);
        signerInformation = SignerInformation.replaceUnsignedAttributes((SignerInformation)signerInformation, (AttributeTable)unsignedAttributes);
        return CMSSignedData.replaceSigners((CMSSignedData)signature, (SignerInformationStore)new SignerInformationStore(signerInformation));
    }
}

