/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.mscab;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;

class CFReserve {
    public byte[] structure1 = new byte[0];
    public byte[] structure2 = new byte[0];
    public int minSize = -1;

    public CFReserve() {
    }

    public CFReserve(CFReserve reserve) {
        this.structure1 = (byte[])reserve.structure1.clone();
        this.structure2 = (byte[])reserve.structure2.clone();
    }

    public void read(byte[] abReserve) throws IOException {
        int length2;
        if (abReserve.length < 4) {
            throw new IOException("Invalid size of the header reserve");
        }
        ByteBuffer buffer = ByteBuffer.wrap(abReserve).order(ByteOrder.LITTLE_ENDIAN);
        int length1 = buffer.getShort() & 0xFFFF;
        if (4 + length1 + (length2 = buffer.getShort() & 0xFFFF) > abReserve.length) {
            throw new IOException("Invalid data in the header reserve");
        }
        this.structure1 = new byte[length1];
        buffer.get(this.structure1);
        this.structure2 = new byte[length2];
        buffer.get(this.structure2);
    }

    public int size() {
        return Math.max(this.minSize, 4 + this.structure1.length + this.structure2.length);
    }

    public boolean isEmpty() {
        return this.structure1.length == 0 && this.structure2.length == 0;
    }

    public ByteBuffer toBuffer() {
        ByteBuffer buffer = ByteBuffer.allocate(this.size()).order(ByteOrder.LITTLE_ENDIAN);
        buffer.putShort((short)this.structure1.length);
        buffer.putShort((short)this.structure2.length);
        buffer.put(this.structure1);
        buffer.put(this.structure2);
        buffer.position(buffer.capacity());
        buffer.flip();
        return buffer;
    }

    public void digest(MessageDigest digest) {
        ByteBuffer buffer = ByteBuffer.allocate(2 + this.structure1.length).order(ByteOrder.LITTLE_ENDIAN);
        buffer.putShort((short)this.structure1.length);
        buffer.put(this.structure1);
        buffer.flip();
        digest.update(buffer);
    }
}

