/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.timestamp;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import net.jsign.DigestAlgorithm;
import net.jsign.asn1.authenticode.AuthenticodeTimeStampRequest;
import net.jsign.timestamp.Timestamper;
import net.jsign.timestamp.TimestampingException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.util.encoders.Base64;

public class AuthenticodeTimestamper
extends Timestamper {
    public AuthenticodeTimestamper() {
        this.setURL("http://timestamp.sectigo.com");
    }

    @Override
    protected CMSSignedData timestamp(DigestAlgorithm algo, byte[] encryptedDigest) throws IOException, TimestampingException {
        AuthenticodeTimeStampRequest timestampRequest = new AuthenticodeTimeStampRequest(encryptedDigest);
        byte[] request = Base64.encode((byte[])timestampRequest.getEncoded("DER"));
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/octet-stream");
        headers.put("Accept", "application/octet-stream");
        byte[] response = this.post(this.tsaurl, request, headers);
        try {
            return new CMSSignedData(Base64.decode((byte[])response));
        }
        catch (Exception e) {
            throw new TimestampingException("Unable to complete the timestamping", e);
        }
    }

    @Override
    protected Collection<X509CertificateHolder> getExtraCertificates(CMSSignedData token) {
        return token.getCertificates().getMatches(null);
    }

    @Override
    protected Attribute getCounterSignature(CMSSignedData token) {
        SignerInformation timestampSignerInformation = (SignerInformation)token.getSignerInfos().getSigners().iterator().next();
        return new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet((ASN1Encodable)timestampSignerInformation.toASN1Structure()));
    }
}

