/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.composite.loggingevent;

import ch.qos.logback.classic.spi.ILoggingEvent;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.logstash.logback.composite.AbstractFieldJsonProvider;
import net.logstash.logback.composite.FieldNamesAware;
import net.logstash.logback.composite.loggingevent.mdc.MdcEntryWriter;
import net.logstash.logback.fieldnames.LogstashFieldNames;

public class MdcJsonProvider
extends AbstractFieldJsonProvider<ILoggingEvent>
implements FieldNamesAware<LogstashFieldNames> {
    protected List<String> includeMdcKeyNames = new ArrayList<String>();
    protected List<String> excludeMdcKeyNames = new ArrayList<String>();
    protected final Map<String, String> mdcKeyFieldNames = new HashMap<String, String>();
    protected final List<MdcEntryWriter> mdcEntryWriters = new ArrayList<MdcEntryWriter>();

    @Override
    public void start() {
        if (!this.includeMdcKeyNames.isEmpty() && !this.excludeMdcKeyNames.isEmpty()) {
            this.addError("Both includeMdcKeyNames and excludeMdcKeyNames are not empty.  Only one is allowed to be not empty.");
        }
        super.start();
    }

    @Override
    public void writeTo(JsonGenerator generator, ILoggingEvent event) throws IOException {
        Map mdcProperties = event.getMDCPropertyMap();
        if (mdcProperties != null && !mdcProperties.isEmpty()) {
            boolean hasWrittenStart = false;
            for (Map.Entry entry : mdcProperties.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null || !this.includeMdcKeyNames.isEmpty() && !this.includeMdcKeyNames.contains(entry.getKey()) || !this.excludeMdcKeyNames.isEmpty() && this.excludeMdcKeyNames.contains(entry.getKey())) continue;
                String fieldName = this.mdcKeyFieldNames.get(entry.getKey());
                if (fieldName == null) {
                    fieldName = (String)entry.getKey();
                }
                if (!hasWrittenStart && this.getFieldName() != null) {
                    generator.writeObjectFieldStart(this.getFieldName());
                    hasWrittenStart = true;
                }
                this.writeMdcEntry(generator, fieldName, (String)entry.getKey(), (String)entry.getValue());
            }
            if (hasWrittenStart) {
                generator.writeEndObject();
            }
        }
    }

    @Override
    public void setFieldNames(LogstashFieldNames fieldNames) {
        this.setFieldName(fieldNames.getMdc());
    }

    public List<String> getIncludeMdcKeyNames() {
        return Collections.unmodifiableList(this.includeMdcKeyNames);
    }

    public void addIncludeMdcKeyName(String includedMdcKeyName) {
        this.includeMdcKeyNames.add(includedMdcKeyName);
    }

    public void setIncludeMdcKeyNames(List<String> includeMdcKeyNames) {
        this.includeMdcKeyNames = new ArrayList<String>(includeMdcKeyNames);
    }

    public List<String> getExcludeMdcKeyNames() {
        return Collections.unmodifiableList(this.excludeMdcKeyNames);
    }

    public void addExcludeMdcKeyName(String excludedMdcKeyName) {
        this.excludeMdcKeyNames.add(excludedMdcKeyName);
    }

    public void setExcludeMdcKeyNames(List<String> excludeMdcKeyNames) {
        this.excludeMdcKeyNames = new ArrayList<String>(excludeMdcKeyNames);
    }

    public Map<String, String> getMdcKeyFieldNames() {
        return this.mdcKeyFieldNames;
    }

    public List<MdcEntryWriter> getMdcEntryWriters() {
        return Collections.unmodifiableList(this.mdcEntryWriters);
    }

    public void addMdcEntryWriter(MdcEntryWriter mdcEntryWriter) {
        this.mdcEntryWriters.add(mdcEntryWriter);
    }

    public void addMdcKeyFieldName(String mdcKeyFieldName) {
        String[] split = mdcKeyFieldName.split("=");
        if (split.length != 2) {
            throw new IllegalArgumentException("mdcKeyFieldName (" + mdcKeyFieldName + ") must be in the form mdcKeyName=fieldName");
        }
        this.mdcKeyFieldNames.put(split[0], split[1]);
    }

    private void writeMdcEntry(JsonGenerator generator, String fieldName, String mdcKey, String mdcValue) throws IOException {
        for (MdcEntryWriter mdcEntryWriter : this.mdcEntryWriters) {
            if (!mdcEntryWriter.writeMdcEntry(generator, fieldName, mdcKey, mdcValue)) continue;
            return;
        }
        generator.writeFieldName(fieldName);
        generator.writeObject((Object)mdcValue);
    }
}

