/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.composite.loggingevent.mdc;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import net.logstash.logback.composite.loggingevent.mdc.MdcEntryWriter;

public class RegexFilteringMdcEntryWriter
implements MdcEntryWriter {
    private Pattern includeMdcKeyPattern;
    private Pattern excludeMdcKeyPattern;
    private final List<MdcEntryWriter> mdcEntryWriters = new ArrayList<MdcEntryWriter>();

    @Override
    public boolean writeMdcEntry(JsonGenerator generator, String fieldName, String mdcKey, String mdcValue) throws IOException {
        if (this.shouldWrite(mdcKey)) {
            for (MdcEntryWriter mdcEntryWriter : this.mdcEntryWriters) {
                if (!mdcEntryWriter.writeMdcEntry(generator, fieldName, mdcKey, mdcValue)) continue;
                return true;
            }
        }
        return false;
    }

    public Pattern getIncludeMdcKeyPattern() {
        return this.includeMdcKeyPattern;
    }

    public void setIncludeMdcKeyPattern(String includeMdcKeyPattern) {
        this.includeMdcKeyPattern = Pattern.compile(includeMdcKeyPattern);
    }

    public Pattern getExcludeMdcKeyPattern() {
        return this.excludeMdcKeyPattern;
    }

    public void setExcludeMdcKeyPattern(String excludeMdcKeyPattern) {
        this.excludeMdcKeyPattern = Pattern.compile(excludeMdcKeyPattern);
    }

    public List<MdcEntryWriter> getMdcEntryWriters() {
        return Collections.unmodifiableList(this.mdcEntryWriters);
    }

    public void addMdcEntryWriter(MdcEntryWriter mdcEntryWriter) {
        this.mdcEntryWriters.add(mdcEntryWriter);
    }

    private boolean shouldWrite(String key) {
        if (this.mdcEntryWriters.isEmpty()) {
            return false;
        }
        boolean includeKey = this.includeMdcKeyPattern == null || this.includeMdcKeyPattern.matcher(key).matches();
        boolean excludeKey = this.excludeMdcKeyPattern != null && this.excludeMdcKeyPattern.matcher(key).matches();
        return includeKey && !excludeKey;
    }
}

