/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.masterthought.cucumber.Configuration;
import net.masterthought.cucumber.ReportBuilder;
import net.masterthought.cucumber.Reportable;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.StringUtils;

public class CucumberReportGeneratorMojo
extends AbstractMojo {
    private String projectName;
    private String buildNumber;
    private File outputDirectory;
    private File cucumberOutput;
    private List<String> jsonFiles = Collections.emptyList();
    private Boolean checkBuildResult;
    private Boolean parallelTesting;
    private Map<String, String> classifications;

    public void execute() throws MojoExecutionException {
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (File file : CucumberReportGeneratorMojo.cucumberFiles(this.cucumberOutput)) {
            list.add(file.getAbsolutePath());
        }
        list.addAll(this.jsonFiles);
        try {
            Configuration configuration = new Configuration(this.outputDirectory, this.projectName);
            configuration.setBuildNumber(this.buildNumber);
            configuration.setParallelTesting(this.parallelTesting.booleanValue());
            if (!MapUtils.isEmpty(this.classifications)) {
                for (Map.Entry<String, String> entry : this.classifications.entrySet()) {
                    configuration.addClassifications(StringUtils.capitalise((String)entry.getKey()), entry.getValue());
                }
            }
            ReportBuilder reportBuilder = new ReportBuilder(list, configuration);
            this.getLog().info((CharSequence)"About to generate Cucumber report.");
            Reportable reportable = reportBuilder.generateReports();
            if (this.checkBuildResult.booleanValue() && (reportable == null || reportable.getFailedSteps() > 0)) {
                throw new MojoExecutionException("BUILD FAILED - Check Report For Details");
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error Found:", e);
        }
    }

    static Collection<File> cucumberFiles(File file) throws MojoExecutionException {
        if (!file.exists()) {
            return Collections.emptyList();
        }
        if (file.isFile()) {
            return Arrays.asList(file);
        }
        return FileUtils.listFiles((File)file, (String[])new String[]{"json"}, (boolean)true);
    }
}

