/*
 * Decompiled with CFR 0.152.
 */
package narou4j;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import narou4j.enums.NovelGenre;
import narou4j.enums.NovelType;
import narou4j.enums.OfParam;
import narou4j.enums.OutputOrder;
import narou4j.enums.SearchWordTarget;
import narou4j.enums.UploadAt;
import narou4j.enums.WarnigTag;
import narou4j.exception.NarouDuplicateException;
import narou4j.exception.NarouOutOfRangeException;

public class GetParameter4Narou {
    Map<String, String> params = new HashMap<String, String>();
    boolean isGzip = true;
    private Set<OfParam> ofParamSet = new HashSet<OfParam>();
    private Set<NovelGenre> novelGenreSet = new TreeSet<NovelGenre>();
    private Set<NovelGenre> notNovelGenreSet = new TreeSet<NovelGenre>();
    private Set<Integer> userIdSet = new TreeSet<Integer>();
    private Set<String> ncodeSet = new TreeSet<String>();

    boolean isSetEmpty(Set set) {
        return set.size() <= 0;
    }

    void setAllParams() {
        if (!this.isSetEmpty(this.ofParamSet)) {
            this.params.put("of", this.getOfParam());
        }
        if (!this.isSetEmpty(this.novelGenreSet)) {
            this.params.put("genre", this.getGenre());
        }
        if (!this.isSetEmpty(this.notNovelGenreSet)) {
            this.params.put("notgenre", this.getNotGenre());
        }
        if (!this.isSetEmpty(this.userIdSet)) {
            this.params.put("userid", this.getUserIds());
        }
        if (!this.isSetEmpty(this.ncodeSet)) {
            this.params.put("ncode", this.getNcodes());
        }
    }

    public void setGzip(int rate) {
        if (rate < 1 || rate > 5) {
            throw new NarouOutOfRangeException("out of gzip Compression level (1 ~ 5)");
        }
        this.params.put("gzip", String.valueOf(rate));
        this.isGzip = true;
    }

    public void notGzip() {
        this.params.remove("gzip");
        this.isGzip = false;
    }

    public void setOfParams(OfParam param) {
        this.ofParamSet.add(param);
    }

    public void setOfParams(OfParam[] params) {
        for (OfParam param : params) {
            this.ofParamSet.add(param);
        }
    }

    String getOfParam() {
        StringBuilder builder = new StringBuilder();
        int i = 1;
        for (OfParam param : this.ofParamSet) {
            builder.append(param.getId());
            if (i != this.ofParamSet.size()) {
                builder.append("-");
            }
            ++i;
        }
        return builder.toString();
    }

    public void setLim(int lim) {
        if (lim < 1 || lim > 500) {
            throw new NarouOutOfRangeException("out of output limit (1 ~ 500)");
        }
        this.params.put("lim", String.valueOf(lim));
    }

    public void setSt(int st) {
        if (st < 1 || st > 2000) {
            throw new NarouOutOfRangeException("out of st number (1 ~ 2000)");
        }
        this.params.put("st", String.valueOf(st));
    }

    public void setOrder(OutputOrder order) {
        this.params.put("order", order.getId());
    }

    public void setSearchWord(String word) {
        this.params.put("word", word);
    }

    public void setNotWord(String word) {
        this.params.put("notword", word);
    }

    public void setSearchTarget(SearchWordTarget target) {
        switch (target) {
            case TITLE: {
                this.params.put("title", String.valueOf(1));
                break;
            }
            case SYNOPSIS: {
                this.params.put("ex", String.valueOf(1));
                break;
            }
            case KEYWORD: {
                this.params.put("keyword", String.valueOf(1));
                break;
            }
            case WRITER: {
                this.params.put("wname", String.valueOf(1));
            }
        }
    }

    public void setGenre(NovelGenre novelGenre) {
        this.novelGenreSet.add(novelGenre);
    }

    public void setGenre(NovelGenre[] genres) {
        for (NovelGenre genre : genres) {
            this.novelGenreSet.add(genre);
        }
    }

    String getGenre() {
        return this.genre2String(this.novelGenreSet);
    }

    public void setNotGenre(NovelGenre genre) {
        this.notNovelGenreSet.add(genre);
    }

    public void setNotGenre(NovelGenre[] genres) {
        for (NovelGenre genre : genres) {
            this.notNovelGenreSet.add(genre);
        }
    }

    String getNotGenre() {
        return this.genre2String(this.notNovelGenreSet);
    }

    public void setUserId(int id) {
        this.userIdSet.add(id);
    }

    public void setUserId(int[] ids) {
        for (int id : ids) {
            this.userIdSet.add(id);
        }
    }

    String getUserIds() {
        StringBuilder builder = new StringBuilder();
        int i = 1;
        for (int userId : this.userIdSet) {
            builder.append(userId);
            if (i != this.userIdSet.size()) {
                builder.append("-");
            }
            ++i;
        }
        return builder.toString();
    }

    public void setWarnigTag(WarnigTag tag) {
        this.params.put(tag.getId(), String.valueOf(1));
    }

    public void setCharacterLength(int length) {
        if (this.params.containsKey("time")) {
            throw new NarouDuplicateException("character length is not used in conjunction with the reading time. ");
        }
        this.params.put("length", String.valueOf(length));
    }

    public void setCharacterLength(int min, int max) {
        if (this.params.containsKey("time")) {
            throw new NarouDuplicateException("character length is not used in conjunction with the reading time. ");
        }
        this.params.put("length", this.range2String(String.valueOf(min), String.valueOf(max)));
    }

    public void setReadTime(int length) {
        if (this.params.containsKey("length")) {
            throw new NarouDuplicateException("reading time is not used in conjunction with the character length. ");
        }
        this.params.put("time", String.valueOf(length));
    }

    public void setReadTime(int min, int max) {
        if (this.params.containsKey("length")) {
            throw new NarouDuplicateException("reading time is not used in conjunction with the character length. ");
        }
        this.params.put("time", this.range2String(String.valueOf(min), String.valueOf(max)));
    }

    public void setConversationRate(int rate) {
        this.params.put("kaiwaritu", String.valueOf(rate));
    }

    public void setConversationRate(int min, int max) {
        this.params.put("kaiwaritu", this.range2String(String.valueOf(min), String.valueOf(max)));
    }

    public void setArtworks(int num) {
        this.params.put("sasie", String.valueOf(num));
    }

    public void setArtworks(int min, int max) {
        this.params.put("sasie", this.range2String(String.valueOf(min), String.valueOf(max)));
    }

    public void setNCode(String ncode) {
        this.ncodeSet.add(ncode);
    }

    public void setNCode(String[] ncodes) {
        for (String ncode : ncodes) {
            this.ncodeSet.add(ncode);
        }
    }

    String getNcodes() {
        StringBuilder builder = new StringBuilder();
        int i = 1;
        for (String ncode : this.ncodeSet) {
            builder.append(ncode);
            if (i != this.ncodeSet.size()) {
                builder.append("-");
            }
            ++i;
        }
        return builder.toString();
    }

    public void setNovelType(NovelType type) {
        this.params.put("type", type.getId());
    }

    public void setExcludeStop(boolean isExclude) {
        if (isExclude) {
            this.params.put("stop", "1");
        } else {
            this.params.put("stop", "2");
        }
    }

    public void setPickup(boolean isPickup) {
        if (isPickup) {
            this.params.put("ispickup", "1");
        } else {
            this.params.put("ispickup", "0");
        }
    }

    public void setLastUploadAt(UploadAt at) {
        this.params.put("lastup", at.getId());
    }

    public void setLastUploadAt(Date date) {
        long unixtime = date.getTime() / 1000L;
        this.params.put("lastup", String.valueOf(unixtime));
    }

    public void setLastUploadAt(Date min, Date max) {
        long minUnixtime = min.getTime() / 1000L;
        long maxUnixtime = max.getTime() / 1000L;
        if (min == null && max != null) {
            this.params.put("lastup", this.range2String("0", String.valueOf(maxUnixtime)));
        } else if (min != null && max == null) {
            this.params.put("lastup", this.range2String(String.valueOf(minUnixtime), "0"));
        } else {
            this.params.put("lastup", this.range2String(String.valueOf(minUnixtime), String.valueOf(maxUnixtime)));
        }
    }

    private String genre2String(Set<NovelGenre> set) {
        StringBuilder builder = new StringBuilder();
        int i = 1;
        for (NovelGenre novelGenre : set) {
            builder.append(novelGenre.getId());
            if (i != set.size()) {
                builder.append("-");
            }
            ++i;
        }
        return builder.toString();
    }

    private String range2String(String min, String max) {
        StringBuilder builder = new StringBuilder();
        if (min.equals("0")) {
            builder.append("-").append(String.valueOf(max));
        } else if (max.equals("0")) {
            builder.append(String.valueOf(min)).append("-");
        } else {
            builder.append(String.valueOf(min)).append("-").append(String.valueOf(max));
        }
        return builder.toString();
    }
}

