/*
 * Decompiled with CFR 0.152.
 */
package narou4j;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import narou4j.GetParameter4Narou;
import narou4j.Utils;
import narou4j.entities.Novel;
import narou4j.entities.NovelBody;
import narou4j.network.NarouApiClient;
import okhttp3.Response;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class Narou
extends GetParameter4Narou {
    private NarouApiClient client;

    public Narou() {
        this.params.put("out", "json");
        this.setGzip(5);
    }

    public List<Novel> getNovels() {
        this.client = new NarouApiClient();
        this.setAllParams();
        try {
            return Utils.response2Json4Novel(this.client.getNovels(this.params), this.isGzip);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Novel getNovel(String ncode) {
        this.client = new NarouApiClient();
        this.params.put("ncode", ncode);
        this.setAllParams();
        List<Novel> novels = null;
        try {
            novels = Utils.response2Json4Novel(this.client.getNovels(this.params), this.isGzip);
            return novels.get(novels.size() - 1);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<NovelBody> getNovelTable(String ncode) {
        this.client = new NarouApiClient();
        this.setAllParams();
        Response response = this.client.getNovelTable(ncode);
        String html = "";
        try {
            html = response.body().string();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (html.equals("")) {
            return null;
        }
        Document document = Jsoup.parse((String)html);
        Elements elements = document.select(".index_box").first().children();
        ArrayList<NovelBody> list = new ArrayList<NovelBody>();
        for (Element element : elements) {
            NovelBody table = new NovelBody();
            if (element.className().equals("chapter_title")) {
                table.setChapter(true);
                table.setTitle(element.ownText());
                list.add(table);
            }
            if (!element.className().equals("novel_sublist2")) continue;
            Element el = element.select(".subtitle a").first();
            table.setTitle(el.ownText());
            String attr = el.attr("href");
            String[] attrs = attr.split("/", 0);
            table.setNcode(attrs[1]);
            table.setPage(Integer.parseInt(attrs[2]));
            list.add(table);
        }
        return list;
    }

    public String getNovelBody(String ncode, int page) {
        if (page == 0) {
            return null;
        }
        this.client = new NarouApiClient();
        this.setAllParams();
        Response response = this.client.getNovelBody(ncode, page);
        String html = "";
        try {
            html = response.body().string();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (html.equals("")) {
            return null;
        }
        Document document = Jsoup.parse((String)html);
        Element element = document.getElementById("novel_honbun");
        String body = element.html();
        String kaigyo = System.getProperty("line.separator");
        body = body.replaceAll(kaigyo, "");
        body = body.replaceAll("<ruby>", "").replaceAll("</ruby>", "").replaceAll("<rb>", "").replaceAll("</rb>", "").replaceAll("<rt>", "").replaceAll("</rt>", "").replaceAll("<rp>", "").replaceAll("</rp>", "");
        body = body.replaceAll("<br>", kaigyo);
        return body;
    }

    public List<Novel> getNovelsAll() {
        List<Novel> novels = this.getNovels();
        novels.remove(0);
        for (Novel novel : novels) {
            Novel novel2 = this.getNovelAll(novel.getNcode());
        }
        return novels;
    }

    public Novel getNovelAll(String ncode) {
        Novel novel = this.getNovel(ncode);
        ArrayList<NovelBody> list = new ArrayList<NovelBody>(this.getNovelTable(ncode));
        for (NovelBody body : list) {
            body.setBody(this.getNovelBody(ncode, body.getPage()));
        }
        novel.setBodies(list);
        return novel;
    }

    public List<NovelBody> getNovelBodyAll(String ncode) {
        ArrayList<NovelBody> list = new ArrayList<NovelBody>(this.getNovelTable(ncode));
        for (NovelBody body : list) {
            body.setBody(this.getNovelBody(ncode, body.getPage()));
        }
        return list;
    }
}

