/*
 * Decompiled with CFR 0.152.
 */
package narou4j;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import narou4j.GetParameter4Ranking;
import narou4j.Utils;
import narou4j.entities.NovelRank;
import narou4j.enums.RankingType;
import narou4j.network.NarouApiClient;

public class Ranking
extends GetParameter4Ranking {
    private NarouApiClient client;

    public Ranking() {
        this.params.put("out", "json");
        this.setGzip(5);
    }

    public List<NovelRank> getRanking(RankingType type) {
        this.client = new NarouApiClient();
        try {
            String typeString = Utils.getRankingType2String(type, new Date());
            this.params.put("rtype", typeString);
            return Utils.response2Json4Ranking(this.client.getRanking(this.params), this.isGzip);
        }
        catch (IOException e) {
            Calendar cal = Calendar.getInstance();
            e.printStackTrace();
            cal.setTime(new Date());
            switch (type) {
                case DAILY: {
                    cal.add(5, -1);
                    break;
                }
                case WEEKLY: {
                    cal.add(5, -7);
                    break;
                }
                case MONTHLY: {
                    cal.add(2, -1);
                    break;
                }
                case QUARTET: {
                    cal.add(2, -3);
                }
            }
            String typeString = Utils.getRankingType2String(type, cal.getTime());
            this.params.put("rtype", typeString);
            try {
                return Utils.response2Json4Ranking(this.client.getRanking(this.params), this.isGzip);
            }
            catch (IOException e1) {
                e1.printStackTrace();
                return null;
            }
        }
    }

    public List<NovelRank> getRanking(RankingType type, Date date) {
        this.client = new NarouApiClient();
        this.params.put("rtype", Utils.getRankingType2String(type, date));
        try {
            return Utils.response2Json4Ranking(this.client.getRanking(this.params), this.isGzip);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<NovelRank> getRankinDetail(String ncode) {
        this.client = new NarouApiClient();
        this.params.put("ncode", ncode);
        try {
            return Utils.response2Json4Ranking(this.client.getRankinDetail(this.params), this.isGzip);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

