/*
 * Decompiled with CFR 0.152.
 */
package narou4j;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.zip.GZIPInputStream;
import narou4j.entities.Novel;
import narou4j.entities.NovelRank;
import narou4j.enums.RankingType;
import okhttp3.Response;

class Utils {
    Utils() {
    }

    static List<Novel> response2Json4Novel(Response response, boolean isGzip) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        String str = Utils.getBodyString(response, isGzip);
        List novels = null;
        try {
            novels = (List)mapper.readValue(str, (TypeReference)new TypeReference<List<Novel>>(){});
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return novels;
    }

    static List<NovelRank> response2Json4Ranking(Response response, boolean isGzip) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        String str = Utils.getBodyString(response, isGzip);
        List rankings = null;
        try {
            rankings = (List)mapper.readValue(str, (TypeReference)new TypeReference<List<NovelRank>>(){});
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return rankings;
    }

    private static String getBodyString(Response response, boolean isGzip) throws IOException {
        if (isGzip) {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(new GZIPInputStream(response.body().byteStream())));){
                String line;
                StringBuilder builder = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    builder.append(line);
                }
                String string = builder.toString();
                return string;
            }
        }
        return response.body().string();
    }

    static String day2ThuesDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("Asia/Tokyo"));
        calendar.setTime(date);
        int week = calendar.get(7);
        if (week == 2 || week == 1) {
            week += 7;
        }
        calendar.add(5, -week);
        calendar.add(5, 3);
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        return format.format(calendar.getTime());
    }

    static String day2MonthOne(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("Asia/Tokyo"));
        calendar.setTime(date);
        int day = calendar.get(5);
        calendar.add(5, -day + 1);
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        return format.format(calendar.getTime());
    }

    static String getRankingType2String(RankingType type, Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        StringBuilder builder = new StringBuilder();
        switch (type) {
            case DAILY: {
                builder.append(format.format(date));
                builder.append(type.getId());
                break;
            }
            case WEEKLY: {
                builder.append(Utils.day2ThuesDay(date));
                builder.append(type.getId());
                break;
            }
            case MONTHLY: {
                builder.append(Utils.day2MonthOne(date));
                builder.append(type.getId());
                break;
            }
            case QUARTET: {
                builder.append(Utils.day2MonthOne(date));
                builder.append(type.getId());
                break;
            }
            default: {
                return "";
            }
        }
        System.out.println(builder.toString());
        return builder.toString();
    }
}

