/*
 * Decompiled with CFR 0.152.
 */
package net.openid.appauth.connectivity;

import android.net.Uri;
import androidx.annotation.NonNull;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import net.openid.appauth.Preconditions;
import net.openid.appauth.connectivity.ConnectionBuilder;

public final class DefaultConnectionBuilder
implements ConnectionBuilder {
    public static final DefaultConnectionBuilder INSTANCE = new DefaultConnectionBuilder();
    private static final int CONNECTION_TIMEOUT_MS = (int)TimeUnit.SECONDS.toMillis(15L);
    private static final int READ_TIMEOUT_MS = (int)TimeUnit.SECONDS.toMillis(10L);
    private static final String HTTPS_SCHEME = "https";

    private DefaultConnectionBuilder() {
    }

    @Override
    @NonNull
    public HttpURLConnection openConnection(@NonNull Uri uri) throws IOException {
        Preconditions.checkNotNull(uri, "url must not be null");
        Preconditions.checkArgument(HTTPS_SCHEME.equals(uri.getScheme()), "only https connections are permitted");
        HttpURLConnection conn = (HttpURLConnection)new URL(uri.toString()).openConnection();
        conn.setConnectTimeout(CONNECTION_TIMEOUT_MS);
        conn.setReadTimeout(READ_TIMEOUT_MS);
        conn.setInstanceFollowRedirects(false);
        return conn;
    }
}

