/*
 * Decompiled with CFR 0.152.
 */
package net.openid.appauth;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.openid.appauth.AsciiStringListUtil;
import net.openid.appauth.AuthorizationException;
import net.openid.appauth.AuthorizationResponse;
import net.openid.appauth.AuthorizationService;
import net.openid.appauth.AuthorizationServiceConfiguration;
import net.openid.appauth.ClientAuthentication;
import net.openid.appauth.ClientSecretBasic;
import net.openid.appauth.ClientSecretPost;
import net.openid.appauth.Clock;
import net.openid.appauth.JsonUtil;
import net.openid.appauth.Logger;
import net.openid.appauth.NoClientAuthentication;
import net.openid.appauth.Preconditions;
import net.openid.appauth.RegistrationResponse;
import net.openid.appauth.SystemClock;
import net.openid.appauth.TokenRequest;
import net.openid.appauth.TokenResponse;
import org.json.JSONException;
import org.json.JSONObject;

public class AuthState {
    public static final int EXPIRY_TIME_TOLERANCE_MS = 60000;
    private static final String KEY_REFRESH_TOKEN = "refreshToken";
    private static final String KEY_SCOPE = "scope";
    private static final String KEY_LAST_AUTHORIZATION_RESPONSE = "lastAuthorizationResponse";
    private static final String KEY_LAST_TOKEN_RESPONSE = "mLastTokenResponse";
    private static final String KEY_AUTHORIZATION_EXCEPTION = "mAuthorizationException";
    private static final String KEY_LAST_REGISTRATION_RESPONSE = "lastRegistrationResponse";
    @Nullable
    private String mRefreshToken;
    @Nullable
    private String mScope;
    @Nullable
    private AuthorizationResponse mLastAuthorizationResponse;
    @Nullable
    private TokenResponse mLastTokenResponse;
    @Nullable
    private RegistrationResponse mLastRegistrationResponse;
    @Nullable
    private AuthorizationException mAuthorizationException;
    private boolean mNeedsTokenRefreshOverride;

    public AuthState() {
    }

    public AuthState(@Nullable AuthorizationResponse authResponse, @Nullable AuthorizationException authError) {
        Preconditions.checkArgument(authResponse != null ^ authError != null, "exactly one of authResponse or authError should be non-null");
        this.update(authResponse, authError);
    }

    public AuthState(@NonNull RegistrationResponse regResponse) {
        this.update(regResponse);
    }

    public AuthState(@NonNull AuthorizationResponse authResponse, @Nullable TokenResponse tokenResponse, @Nullable AuthorizationException authException) {
        this(authResponse, null);
        this.update(tokenResponse, authException);
    }

    @Nullable
    public String getRefreshToken() {
        return this.mRefreshToken;
    }

    @Nullable
    public String getScope() {
        return this.mScope;
    }

    @Nullable
    public Set<String> getScopeSet() {
        return AsciiStringListUtil.stringToSet(this.mScope);
    }

    @Nullable
    public AuthorizationResponse getLastAuthorizationResponse() {
        return this.mLastAuthorizationResponse;
    }

    @Nullable
    public TokenResponse getLastTokenResponse() {
        return this.mLastTokenResponse;
    }

    @Nullable
    public RegistrationResponse getLastRegistrationResponse() {
        return this.mLastRegistrationResponse;
    }

    @Nullable
    public AuthorizationServiceConfiguration getAuthorizationServiceConfiguration() {
        if (this.mLastAuthorizationResponse != null) {
            return this.mLastAuthorizationResponse.request.configuration;
        }
        return null;
    }

    @Nullable
    public String getAccessToken() {
        if (this.mAuthorizationException != null) {
            return null;
        }
        if (this.mLastTokenResponse != null && this.mLastTokenResponse.accessToken != null) {
            return this.mLastTokenResponse.accessToken;
        }
        if (this.mLastAuthorizationResponse != null) {
            return this.mLastAuthorizationResponse.accessToken;
        }
        return null;
    }

    @Nullable
    public Long getAccessTokenExpirationTime() {
        if (this.mAuthorizationException != null) {
            return null;
        }
        if (this.mLastTokenResponse != null && this.mLastTokenResponse.accessToken != null) {
            return this.mLastTokenResponse.accessTokenExpirationTime;
        }
        if (this.mLastAuthorizationResponse != null && this.mLastAuthorizationResponse.accessToken != null) {
            return this.mLastAuthorizationResponse.accessTokenExpirationTime;
        }
        return null;
    }

    @Nullable
    public String getIdToken() {
        if (this.mAuthorizationException != null) {
            return null;
        }
        if (this.mLastTokenResponse != null && this.mLastTokenResponse.idToken != null) {
            return this.mLastTokenResponse.idToken;
        }
        if (this.mLastAuthorizationResponse != null) {
            return this.mLastAuthorizationResponse.idToken;
        }
        return null;
    }

    public String getClientSecret() {
        if (this.mLastRegistrationResponse != null) {
            return this.mLastRegistrationResponse.clientSecret;
        }
        return null;
    }

    @Nullable
    public Long getClientSecretExpirationTime() {
        if (this.mLastRegistrationResponse != null) {
            return this.mLastRegistrationResponse.clientSecretExpiresAt;
        }
        return null;
    }

    public boolean isAuthorized() {
        return this.mAuthorizationException == null && (this.getAccessToken() != null || this.getIdToken() != null);
    }

    @Nullable
    public AuthorizationException getAuthorizationException() {
        return this.mAuthorizationException;
    }

    public boolean getNeedsTokenRefresh() {
        return this.getNeedsTokenRefresh(SystemClock.INSTANCE);
    }

    @VisibleForTesting
    boolean getNeedsTokenRefresh(Clock clock) {
        if (this.mNeedsTokenRefreshOverride) {
            return true;
        }
        if (this.getAccessTokenExpirationTime() == null) {
            return this.getAccessToken() == null;
        }
        return this.getAccessTokenExpirationTime() <= clock.getCurrentTimeMillis() + 60000L;
    }

    public void setNeedsTokenRefresh(boolean needsTokenRefresh) {
        this.mNeedsTokenRefreshOverride = needsTokenRefresh;
    }

    public boolean hasClientSecretExpired() {
        return this.hasClientSecretExpired(SystemClock.INSTANCE);
    }

    @VisibleForTesting
    boolean hasClientSecretExpired(Clock clock) {
        if (this.getClientSecretExpirationTime() == null || this.getClientSecretExpirationTime() == 0L) {
            return false;
        }
        return this.getClientSecretExpirationTime() <= clock.getCurrentTimeMillis();
    }

    public void update(@Nullable AuthorizationResponse authResponse, @Nullable AuthorizationException authException) {
        Preconditions.checkArgument(authResponse != null ^ authException != null, "exactly one of authResponse or authException should be non-null");
        if (authException != null) {
            if (authException.type == 1) {
                this.mAuthorizationException = authException;
            }
            return;
        }
        this.mLastAuthorizationResponse = authResponse;
        this.mLastTokenResponse = null;
        this.mRefreshToken = null;
        this.mAuthorizationException = null;
        this.mScope = authResponse.scope != null ? authResponse.scope : authResponse.request.scope;
    }

    public void update(@Nullable TokenResponse tokenResponse, @Nullable AuthorizationException authException) {
        Preconditions.checkArgument(tokenResponse != null ^ authException != null, "exactly one of tokenResponse or authException should be non-null");
        if (this.mAuthorizationException != null) {
            Logger.warn("AuthState.update should not be called in an error state (%s), call updatewith the result of the fresh authorization response first", this.mAuthorizationException);
            this.mAuthorizationException = null;
        }
        if (authException != null) {
            if (authException.type == 2) {
                this.mAuthorizationException = authException;
            }
            return;
        }
        this.mLastTokenResponse = tokenResponse;
        if (tokenResponse.scope != null) {
            this.mScope = tokenResponse.scope;
        }
        if (tokenResponse.refreshToken != null) {
            this.mRefreshToken = tokenResponse.refreshToken;
        }
    }

    public void update(@Nullable RegistrationResponse regResponse) {
        this.mLastRegistrationResponse = regResponse;
        this.mRefreshToken = null;
        this.mScope = null;
        this.mLastAuthorizationResponse = null;
        this.mLastTokenResponse = null;
        this.mAuthorizationException = null;
    }

    public void performActionWithFreshTokens(@NonNull AuthorizationService service, @NonNull AuthStateAction action) {
        this.performActionWithFreshTokens(service, Collections.emptyMap(), action);
    }

    public void performActionWithFreshTokens(@NonNull AuthorizationService service, @NonNull Map<String, String> refreshTokenAdditionalParams, @NonNull AuthStateAction action) {
        this.performActionWithFreshTokens(service, refreshTokenAdditionalParams, SystemClock.INSTANCE, action);
    }

    @VisibleForTesting
    void performActionWithFreshTokens(@NonNull AuthorizationService service, @NonNull Map<String, String> refreshTokenAdditionalParams, @NonNull Clock clock, final @NonNull AuthStateAction action) {
        Preconditions.checkNotNull(service, "service cannot be null");
        Preconditions.checkNotNull(refreshTokenAdditionalParams, "additional params cannot be null");
        Preconditions.checkNotNull(clock, "clock cannot be null");
        Preconditions.checkNotNull(action, "action cannot be null");
        if (!this.getNeedsTokenRefresh(clock)) {
            action.execute(this.getAccessToken(), this.getIdToken(), null);
            return;
        }
        if (this.mRefreshToken == null) {
            AuthorizationException ex = AuthorizationException.fromTemplate(AuthorizationException.AuthorizationRequestErrors.CLIENT_ERROR, new IllegalStateException("No refresh token available and token have expired"));
            action.execute(null, null, ex);
            return;
        }
        service.performTokenRequest(this.createTokenRefreshRequest(refreshTokenAdditionalParams), new AuthorizationService.TokenResponseCallback(){

            @Override
            public void onTokenRequestCompleted(@Nullable TokenResponse response, @Nullable AuthorizationException ex) {
                AuthState.this.update(response, ex);
                if (ex == null) {
                    AuthState.this.mNeedsTokenRefreshOverride = false;
                    action.execute(AuthState.this.getAccessToken(), AuthState.this.getIdToken(), null);
                } else {
                    action.execute(null, null, ex);
                }
            }
        });
    }

    public TokenRequest createTokenRefreshRequest() {
        return this.createTokenRefreshRequest(Collections.emptyMap());
    }

    public TokenRequest createTokenRefreshRequest(@NonNull Map<String, String> additionalParameters) {
        if (this.mRefreshToken == null) {
            throw new IllegalStateException("No refresh token available for refresh request");
        }
        if (this.mLastAuthorizationResponse == null) {
            throw new IllegalStateException("No authorization configuration available for refresh request");
        }
        return new TokenRequest.Builder(this.mLastAuthorizationResponse.request.configuration, this.mLastAuthorizationResponse.request.clientId).setGrantType("refresh_token").setScope(this.mLastAuthorizationResponse.request.scope).setRefreshToken(this.mRefreshToken).setAdditionalParameters(additionalParameters).build();
    }

    public JSONObject jsonSerialize() {
        JSONObject json = new JSONObject();
        JsonUtil.putIfNotNull(json, KEY_REFRESH_TOKEN, this.mRefreshToken);
        JsonUtil.putIfNotNull(json, KEY_SCOPE, this.mScope);
        if (this.mAuthorizationException != null) {
            JsonUtil.put(json, KEY_AUTHORIZATION_EXCEPTION, this.mAuthorizationException.toJson());
        }
        if (this.mLastAuthorizationResponse != null) {
            JsonUtil.put(json, KEY_LAST_AUTHORIZATION_RESPONSE, this.mLastAuthorizationResponse.jsonSerialize());
        }
        if (this.mLastTokenResponse != null) {
            JsonUtil.put(json, KEY_LAST_TOKEN_RESPONSE, this.mLastTokenResponse.jsonSerialize());
        }
        if (this.mLastRegistrationResponse != null) {
            JsonUtil.put(json, KEY_LAST_REGISTRATION_RESPONSE, this.mLastRegistrationResponse.jsonSerialize());
        }
        return json;
    }

    public String jsonSerializeString() {
        return this.jsonSerialize().toString();
    }

    public static AuthState jsonDeserialize(@NonNull JSONObject json) throws JSONException {
        Preconditions.checkNotNull(json, "json cannot be null");
        AuthState state = new AuthState();
        state.mRefreshToken = JsonUtil.getStringIfDefined(json, KEY_REFRESH_TOKEN);
        state.mScope = JsonUtil.getStringIfDefined(json, KEY_SCOPE);
        if (json.has(KEY_AUTHORIZATION_EXCEPTION)) {
            state.mAuthorizationException = AuthorizationException.fromJson(json.getJSONObject(KEY_AUTHORIZATION_EXCEPTION));
        }
        if (json.has(KEY_LAST_AUTHORIZATION_RESPONSE)) {
            state.mLastAuthorizationResponse = AuthorizationResponse.jsonDeserialize(json.getJSONObject(KEY_LAST_AUTHORIZATION_RESPONSE));
        }
        if (json.has(KEY_LAST_TOKEN_RESPONSE)) {
            state.mLastTokenResponse = TokenResponse.jsonDeserialize(json.getJSONObject(KEY_LAST_TOKEN_RESPONSE));
        }
        if (json.has(KEY_LAST_REGISTRATION_RESPONSE)) {
            state.mLastRegistrationResponse = RegistrationResponse.jsonDeserialize(json.getJSONObject(KEY_LAST_REGISTRATION_RESPONSE));
        }
        return state;
    }

    public static AuthState jsonDeserialize(@NonNull String jsonStr) throws JSONException {
        Preconditions.checkNotEmpty(jsonStr, "jsonStr cannot be null or empty");
        return AuthState.jsonDeserialize(new JSONObject(jsonStr));
    }

    public ClientAuthentication getClientAuthentication() throws ClientAuthentication.UnsupportedAuthenticationMethod {
        if (this.getClientSecret() == null) {
            return NoClientAuthentication.INSTANCE;
        }
        if (this.mLastRegistrationResponse.tokenEndpointAuthMethod == null) {
            return new ClientSecretBasic(this.getClientSecret());
        }
        switch (this.mLastRegistrationResponse.tokenEndpointAuthMethod) {
            case "client_secret_basic": {
                return new ClientSecretBasic(this.getClientSecret());
            }
            case "client_secret_post": {
                return new ClientSecretPost(this.getClientSecret());
            }
            case "none": {
                return NoClientAuthentication.INSTANCE;
            }
        }
        throw new ClientAuthentication.UnsupportedAuthenticationMethod(this.mLastRegistrationResponse.tokenEndpointAuthMethod);
    }

    public static interface AuthStateAction {
        public void execute(@Nullable String var1, @Nullable String var2, @Nullable AuthorizationException var3);
    }
}

