/*
 * Decompiled with CFR 0.152.
 */
package net.openid.appauth;

import android.app.PendingIntent;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.AsyncTask;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.customtabs.CustomTabsIntent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.util.Map;
import net.openid.appauth.AppAuthConfiguration;
import net.openid.appauth.AuthorizationException;
import net.openid.appauth.AuthorizationManagementActivity;
import net.openid.appauth.AuthorizationRequest;
import net.openid.appauth.ClientAuthentication;
import net.openid.appauth.CustomTabManager;
import net.openid.appauth.Logger;
import net.openid.appauth.NoClientAuthentication;
import net.openid.appauth.Preconditions;
import net.openid.appauth.RegistrationRequest;
import net.openid.appauth.RegistrationResponse;
import net.openid.appauth.TokenRequest;
import net.openid.appauth.TokenResponse;
import net.openid.appauth.UriUtil;
import net.openid.appauth.Utils;
import net.openid.appauth.browser.BrowserDescriptor;
import net.openid.appauth.browser.BrowserSelector;
import org.json.JSONException;
import org.json.JSONObject;

public class AuthorizationService {
    @VisibleForTesting
    Context mContext;
    @NonNull
    private final AppAuthConfiguration mClientConfiguration;
    @NonNull
    private final CustomTabManager mCustomTabManager;
    @Nullable
    private final BrowserDescriptor mBrowser;
    private boolean mDisposed = false;

    public AuthorizationService(@NonNull Context context) {
        this(context, AppAuthConfiguration.DEFAULT);
    }

    public AuthorizationService(@NonNull Context context, @NonNull AppAuthConfiguration clientConfiguration) {
        this(context, clientConfiguration, BrowserSelector.select(context, clientConfiguration.getBrowserMatcher()), new CustomTabManager(context));
    }

    @VisibleForTesting
    AuthorizationService(@NonNull Context context, @NonNull AppAuthConfiguration clientConfiguration, @Nullable BrowserDescriptor browser, @NonNull CustomTabManager customTabManager) {
        this.mContext = Preconditions.checkNotNull(context);
        this.mClientConfiguration = clientConfiguration;
        this.mCustomTabManager = customTabManager;
        this.mBrowser = browser;
        if (browser != null && browser.useCustomTab.booleanValue()) {
            this.mCustomTabManager.bind(browser.packageName);
        }
    }

    public CustomTabsIntent.Builder createCustomTabsIntentBuilder() {
        this.checkNotDisposed();
        return this.mCustomTabManager.createCustomTabsIntentBuilder();
    }

    public void performAuthorizationRequest(@NonNull AuthorizationRequest request, @NonNull PendingIntent completedIntent) {
        this.performAuthorizationRequest(request, completedIntent, null, this.createCustomTabsIntentBuilder().build());
    }

    public void performAuthorizationRequest(@NonNull AuthorizationRequest request, @NonNull PendingIntent completedIntent, @NonNull PendingIntent canceledIntent) {
        this.performAuthorizationRequest(request, completedIntent, canceledIntent, this.createCustomTabsIntentBuilder().build());
    }

    public void performAuthorizationRequest(@NonNull AuthorizationRequest request, @NonNull PendingIntent completedIntent, @NonNull CustomTabsIntent customTabsIntent) {
        this.performAuthorizationRequest(request, completedIntent, null, customTabsIntent);
    }

    public void performAuthorizationRequest(@NonNull AuthorizationRequest request, @NonNull PendingIntent completedIntent, @Nullable PendingIntent canceledIntent, @NonNull CustomTabsIntent customTabsIntent) {
        this.checkNotDisposed();
        if (this.mBrowser == null) {
            throw new ActivityNotFoundException();
        }
        Uri requestUri = request.toUri();
        Intent intent = this.mBrowser.useCustomTab != false ? customTabsIntent.intent : new Intent("android.intent.action.VIEW");
        intent.setPackage(this.mBrowser.packageName);
        intent.setData(requestUri);
        Logger.debug("Using %s as browser for auth, custom tab = %s", intent.getPackage(), this.mBrowser.useCustomTab.toString());
        intent.putExtra("android.support.customtabs.extra.TITLE_VISIBILITY", 0);
        intent.addFlags(0x40000000);
        Logger.debug("Initiating authorization request to %s", request.configuration.authorizationEndpoint);
        this.mContext.startActivity(AuthorizationManagementActivity.createStartIntent(this.mContext, request, intent, completedIntent, canceledIntent));
    }

    public void performTokenRequest(@NonNull TokenRequest request, @NonNull TokenResponseCallback callback) {
        this.checkNotDisposed();
        Logger.debug("Initiating code exchange request to %s", request.configuration.tokenEndpoint);
        new TokenRequestTask(request, NoClientAuthentication.INSTANCE, callback).execute(new Void[0]);
    }

    public void performTokenRequest(@NonNull TokenRequest request, @NonNull ClientAuthentication clientAuthentication, @NonNull TokenResponseCallback callback) {
        this.checkNotDisposed();
        Logger.debug("Initiating code exchange request to %s", request.configuration.tokenEndpoint);
        new TokenRequestTask(request, clientAuthentication, callback).execute(new Void[0]);
    }

    public void performRegistrationRequest(@NonNull RegistrationRequest request, @NonNull RegistrationResponseCallback callback) {
        this.checkNotDisposed();
        Logger.debug("Initiating dynamic client registration %s", request.configuration.registrationEndpoint.toString());
        new RegistrationRequestTask(request, callback).execute(new Void[0]);
    }

    public void dispose() {
        if (this.mDisposed) {
            return;
        }
        this.mCustomTabManager.unbind();
        this.mDisposed = true;
    }

    private void checkNotDisposed() {
        if (this.mDisposed) {
            throw new IllegalStateException("Service has been disposed and rendered inoperable");
        }
    }

    public static interface RegistrationResponseCallback {
        public void onRegistrationRequestCompleted(@Nullable RegistrationResponse var1, @Nullable AuthorizationException var2);
    }

    private class RegistrationRequestTask
    extends AsyncTask<Void, Void, JSONObject> {
        private RegistrationRequest mRequest;
        private RegistrationResponseCallback mCallback;
        private AuthorizationException mException;

        RegistrationRequestTask(RegistrationRequest request, RegistrationResponseCallback callback) {
            this.mRequest = request;
            this.mCallback = callback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        protected JSONObject doInBackground(Void ... voids) {
            block7: {
                InputStream is = null;
                String postData = this.mRequest.toJsonString();
                try {
                    HttpURLConnection conn = AuthorizationService.this.mClientConfiguration.getConnectionBuilder().openConnection(this.mRequest.configuration.registrationEndpoint);
                    conn.setRequestMethod("POST");
                    conn.setDoOutput(true);
                    conn.setRequestProperty("Content-Length", String.valueOf(postData.length()));
                    OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
                    wr.write(postData);
                    wr.flush();
                    is = conn.getInputStream();
                    String response = Utils.readInputStream(is);
                    JSONObject jSONObject = new JSONObject(response);
                    Utils.closeQuietly(is);
                    return jSONObject;
                }
                catch (IOException ex) {
                    Logger.debugWithStack(ex, "Failed to complete registration request", new Object[0]);
                    this.mException = AuthorizationException.fromTemplate(AuthorizationException.GeneralErrors.NETWORK_ERROR, ex);
                }
                catch (JSONException ex2) {
                    Logger.debugWithStack(ex2, "Failed to complete registration request", new Object[0]);
                    this.mException = AuthorizationException.fromTemplate(AuthorizationException.GeneralErrors.JSON_DESERIALIZATION_ERROR, ex2);
                    break block7;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    Utils.closeQuietly(is);
                }
            }
            return null;
        }

        protected void onPostExecute(JSONObject json) {
            RegistrationResponse response;
            if (this.mException != null) {
                this.mCallback.onRegistrationRequestCompleted(null, this.mException);
                return;
            }
            if (json.has("error")) {
                AuthorizationException ex;
                try {
                    String error = json.getString("error");
                    ex = AuthorizationException.fromOAuthTemplate(AuthorizationException.RegistrationRequestErrors.byString(error), error, json.getString("error_description"), UriUtil.parseUriIfAvailable(json.getString("error_uri")));
                }
                catch (JSONException jsonEx) {
                    ex = AuthorizationException.fromTemplate(AuthorizationException.GeneralErrors.JSON_DESERIALIZATION_ERROR, jsonEx);
                }
                this.mCallback.onRegistrationRequestCompleted(null, ex);
                return;
            }
            try {
                response = new RegistrationResponse.Builder(this.mRequest).fromResponseJson(json).build();
            }
            catch (JSONException jsonEx) {
                this.mCallback.onRegistrationRequestCompleted(null, AuthorizationException.fromTemplate(AuthorizationException.GeneralErrors.JSON_DESERIALIZATION_ERROR, jsonEx));
                return;
            }
            catch (RegistrationResponse.MissingArgumentException ex) {
                Logger.errorWithStack(ex, "Malformed registration response", new Object[0]);
                this.mException = AuthorizationException.fromTemplate(AuthorizationException.GeneralErrors.INVALID_REGISTRATION_RESPONSE, ex);
                return;
            }
            Logger.debug("Dynamic registration with %s completed", this.mRequest.configuration.registrationEndpoint);
            this.mCallback.onRegistrationRequestCompleted(response, null);
        }
    }

    public static interface TokenResponseCallback {
        public void onTokenRequestCompleted(@Nullable TokenResponse var1, @Nullable AuthorizationException var2);
    }

    private class TokenRequestTask
    extends AsyncTask<Void, Void, JSONObject> {
        private TokenRequest mRequest;
        private TokenResponseCallback mCallback;
        private ClientAuthentication mClientAuthentication;
        private AuthorizationException mException;

        TokenRequestTask(@NonNull TokenRequest request, ClientAuthentication clientAuthentication, TokenResponseCallback callback) {
            this.mRequest = request;
            this.mCallback = callback;
            this.mClientAuthentication = clientAuthentication;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        protected JSONObject doInBackground(Void ... voids) {
            block10: {
                InputStream is = null;
                try {
                    HttpURLConnection conn = AuthorizationService.this.mClientConfiguration.getConnectionBuilder().openConnection(this.mRequest.configuration.tokenEndpoint);
                    conn.setRequestMethod("POST");
                    conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                    conn.setDoOutput(true);
                    Map<String, String> headers = this.mClientAuthentication.getRequestHeaders(this.mRequest.clientId);
                    if (headers != null) {
                        for (Map.Entry<String, String> header : headers.entrySet()) {
                            conn.setRequestProperty(header.getKey(), header.getValue());
                        }
                    }
                    Map<String, String> parameters = this.mRequest.getRequestParameters();
                    Map<String, String> clientAuthParams = this.mClientAuthentication.getRequestParameters(this.mRequest.clientId);
                    if (clientAuthParams != null) {
                        parameters.putAll(clientAuthParams);
                    }
                    String queryData = UriUtil.formUrlEncode(parameters);
                    conn.setRequestProperty("Content-Length", String.valueOf(queryData.length()));
                    OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
                    wr.write(queryData);
                    wr.flush();
                    is = conn.getInputStream();
                    String response = Utils.readInputStream(is);
                    JSONObject jSONObject = new JSONObject(response);
                    Utils.closeQuietly(is);
                    return jSONObject;
                }
                catch (IOException ex) {
                    Logger.debugWithStack(ex, "Failed to complete exchange request", new Object[0]);
                    this.mException = AuthorizationException.fromTemplate(AuthorizationException.GeneralErrors.NETWORK_ERROR, ex);
                }
                catch (JSONException ex2) {
                    Logger.debugWithStack(ex2, "Failed to complete exchange request", new Object[0]);
                    this.mException = AuthorizationException.fromTemplate(AuthorizationException.GeneralErrors.JSON_DESERIALIZATION_ERROR, ex2);
                    break block10;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    Utils.closeQuietly(is);
                }
            }
            return null;
        }

        protected void onPostExecute(JSONObject json) {
            TokenResponse response;
            if (this.mException != null) {
                this.mCallback.onTokenRequestCompleted(null, this.mException);
                return;
            }
            if (json.has("error")) {
                AuthorizationException ex;
                try {
                    String error = json.getString("error");
                    ex = AuthorizationException.fromOAuthTemplate(AuthorizationException.TokenRequestErrors.byString(error), error, json.getString("error_description"), UriUtil.parseUriIfAvailable(json.getString("error_uri")));
                }
                catch (JSONException jsonEx) {
                    ex = AuthorizationException.fromTemplate(AuthorizationException.GeneralErrors.JSON_DESERIALIZATION_ERROR, jsonEx);
                }
                this.mCallback.onTokenRequestCompleted(null, ex);
                return;
            }
            try {
                response = new TokenResponse.Builder(this.mRequest).fromResponseJson(json).build();
            }
            catch (JSONException jsonEx) {
                this.mCallback.onTokenRequestCompleted(null, AuthorizationException.fromTemplate(AuthorizationException.GeneralErrors.JSON_DESERIALIZATION_ERROR, jsonEx));
                return;
            }
            Logger.debug("Token exchange with %s completed", this.mRequest.configuration.tokenEndpoint);
            this.mCallback.onTokenRequestCompleted(response, null);
        }
    }
}

