/*
 * Decompiled with CFR 0.152.
 */
package net.openid.appauth;

import android.net.Uri;
import android.os.AsyncTask;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import net.openid.appauth.AuthorizationException;
import net.openid.appauth.AuthorizationServiceDiscovery;
import net.openid.appauth.JsonUtil;
import net.openid.appauth.Preconditions;
import net.openid.appauth.connectivity.ConnectionBuilder;
import net.openid.appauth.connectivity.DefaultConnectionBuilder;
import org.json.JSONException;
import org.json.JSONObject;

public class AuthorizationServiceConfiguration {
    public static final String WELL_KNOWN_PATH = ".well-known";
    public static final String OPENID_CONFIGURATION_RESOURCE = "openid-configuration";
    private static final String KEY_AUTHORIZATION_ENDPOINT = "authorizationEndpoint";
    private static final String KEY_TOKEN_ENDPOINT = "tokenEndpoint";
    private static final String KEY_REGISTRATION_ENDPOINT = "registrationEndpoint";
    private static final String KEY_DISCOVERY_DOC = "discoveryDoc";
    @NonNull
    public final Uri authorizationEndpoint;
    @NonNull
    public final Uri tokenEndpoint;
    @Nullable
    public final Uri registrationEndpoint;
    @Nullable
    public final AuthorizationServiceDiscovery discoveryDoc;

    public AuthorizationServiceConfiguration(@NonNull Uri authorizationEndpoint, @NonNull Uri tokenEndpoint, @Nullable Uri registrationEndpoint) {
        this.authorizationEndpoint = Preconditions.checkNotNull(authorizationEndpoint);
        this.tokenEndpoint = Preconditions.checkNotNull(tokenEndpoint);
        this.registrationEndpoint = registrationEndpoint;
        this.discoveryDoc = null;
    }

    public AuthorizationServiceConfiguration(@NonNull AuthorizationServiceDiscovery discoveryDoc) {
        Preconditions.checkNotNull(discoveryDoc, "docJson cannot be null");
        this.discoveryDoc = discoveryDoc;
        this.authorizationEndpoint = discoveryDoc.getAuthorizationEndpoint();
        this.tokenEndpoint = discoveryDoc.getTokenEndpoint();
        this.registrationEndpoint = discoveryDoc.getRegistrationEndpoint();
    }

    @NonNull
    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        JsonUtil.put(json, KEY_AUTHORIZATION_ENDPOINT, this.authorizationEndpoint.toString());
        JsonUtil.put(json, KEY_TOKEN_ENDPOINT, this.tokenEndpoint.toString());
        if (this.registrationEndpoint != null) {
            JsonUtil.put(json, KEY_REGISTRATION_ENDPOINT, this.registrationEndpoint.toString());
        }
        if (this.discoveryDoc != null) {
            JsonUtil.put(json, KEY_DISCOVERY_DOC, this.discoveryDoc.docJson);
        }
        return json;
    }

    public String toJsonString() {
        return this.toJson().toString();
    }

    @NonNull
    public static AuthorizationServiceConfiguration fromJson(@NonNull JSONObject json) throws JSONException {
        Preconditions.checkNotNull(json, "json object cannot be null");
        if (json.has(KEY_DISCOVERY_DOC)) {
            try {
                AuthorizationServiceDiscovery discoveryDoc = new AuthorizationServiceDiscovery(json.optJSONObject(KEY_DISCOVERY_DOC));
                return new AuthorizationServiceConfiguration(discoveryDoc);
            }
            catch (AuthorizationServiceDiscovery.MissingArgumentException ex) {
                throw new JSONException("Missing required field in discovery doc: " + ex.getMissingField());
            }
        }
        Preconditions.checkArgument(json.has(KEY_AUTHORIZATION_ENDPOINT), "missing authorizationEndpoint");
        Preconditions.checkArgument(json.has(KEY_TOKEN_ENDPOINT), "missing tokenEndpoint");
        return new AuthorizationServiceConfiguration(JsonUtil.getUri(json, KEY_AUTHORIZATION_ENDPOINT), JsonUtil.getUri(json, KEY_TOKEN_ENDPOINT), JsonUtil.getUriIfDefined(json, KEY_REGISTRATION_ENDPOINT));
    }

    public static AuthorizationServiceConfiguration fromJson(@NonNull String jsonStr) throws JSONException {
        Preconditions.checkNotNull(jsonStr, "json cannot be null");
        return AuthorizationServiceConfiguration.fromJson(new JSONObject(jsonStr));
    }

    public static void fetchFromIssuer(@NonNull Uri openIdConnectIssuerUri, @NonNull RetrieveConfigurationCallback callback) {
        AuthorizationServiceConfiguration.fetchFromUrl(AuthorizationServiceConfiguration.buildConfigurationUriFromIssuer(openIdConnectIssuerUri), callback);
    }

    static Uri buildConfigurationUriFromIssuer(Uri openIdConnectIssuerUri) {
        return openIdConnectIssuerUri.buildUpon().appendPath(WELL_KNOWN_PATH).appendPath(OPENID_CONFIGURATION_RESOURCE).build();
    }

    public static void fetchFromUrl(@NonNull Uri openIdConnectDiscoveryUri, @NonNull RetrieveConfigurationCallback callback) {
        AuthorizationServiceConfiguration.fetchFromUrl(openIdConnectDiscoveryUri, callback, DefaultConnectionBuilder.INSTANCE);
    }

    public static void fetchFromUrl(@NonNull Uri openIdConnectDiscoveryUri, @NonNull RetrieveConfigurationCallback callback, @NonNull ConnectionBuilder connectionBuilder) {
        Preconditions.checkNotNull(openIdConnectDiscoveryUri, "openIDConnectDiscoveryUri cannot be null");
        Preconditions.checkNotNull(callback, "callback cannot be null");
        Preconditions.checkNotNull(connectionBuilder, "connectionBuilder must not be null");
        new ConfigurationRetrievalAsyncTask(openIdConnectDiscoveryUri, connectionBuilder, callback).execute(new Void[0]);
    }

    private static class ConfigurationRetrievalAsyncTask
    extends AsyncTask<Void, Void, AuthorizationServiceConfiguration> {
        private Uri mUri;
        private ConnectionBuilder mConnectionBuilder;
        private RetrieveConfigurationCallback mCallback;
        private AuthorizationException mException;

        ConfigurationRetrievalAsyncTask(Uri uri, ConnectionBuilder connectionBuilder, RetrieveConfigurationCallback callback) {
            this.mUri = uri;
            this.mConnectionBuilder = connectionBuilder;
            this.mCallback = callback;
            this.mException = null;
        }

        /*
         * Exception decompiling
         */
        protected AuthorizationServiceConfiguration doInBackground(Void ... voids) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        protected void onPostExecute(AuthorizationServiceConfiguration configuration) {
            if (this.mException != null) {
                this.mCallback.onFetchConfigurationCompleted(null, this.mException);
            } else {
                this.mCallback.onFetchConfigurationCompleted(configuration, null);
            }
        }
    }

    public static interface RetrieveConfigurationCallback {
        public void onFetchConfigurationCompleted(@Nullable AuthorizationServiceConfiguration var1, @Nullable AuthorizationException var2);
    }
}

