/*
 * Decompiled with CFR 0.152.
 */
package net.openid.appauth;

import android.support.annotation.NonNull;
import android.util.Base64;
import java.util.Collections;
import java.util.Map;
import net.openid.appauth.ClientAuthentication;
import net.openid.appauth.Preconditions;

public class ClientSecretBasic
implements ClientAuthentication {
    public static final String NAME = "client_secret_basic";
    @NonNull
    private String mClientSecret;

    public ClientSecretBasic(@NonNull String clientSecret) {
        this.mClientSecret = Preconditions.checkNotNull(clientSecret, "mClientSecret cannot be null");
    }

    @Override
    public final Map<String, String> getRequestHeaders(String clientId) {
        String credentials = clientId + ":" + this.mClientSecret;
        String basicAuth = Base64.encodeToString((byte[])credentials.getBytes(), (int)2);
        return Collections.singletonMap("Authorization", "Basic " + basicAuth);
    }

    @Override
    public final Map<String, String> getRequestParameters(String clientId) {
        return null;
    }
}

