/*
 * Decompiled with CFR 0.152.
 */
package net.openid.appauth;

import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.customtabs.CustomTabsClient;
import android.support.customtabs.CustomTabsIntent;
import android.support.customtabs.CustomTabsServiceConnection;
import android.support.customtabs.CustomTabsSession;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import net.openid.appauth.Logger;

class CustomTabManager {
    private static final long CLIENT_WAIT_TIME = 1L;
    @NonNull
    private final Context mContext;
    @NonNull
    private final AtomicReference<CustomTabsClient> mClient;
    @NonNull
    private final CountDownLatch mClientLatch;
    @Nullable
    private CustomTabsServiceConnection mConnection;

    CustomTabManager(@NonNull Context context) {
        this.mContext = context;
        this.mClient = new AtomicReference();
        this.mClientLatch = new CountDownLatch(1);
    }

    public synchronized void bind(@NonNull String browserPackage) {
        if (this.mConnection != null) {
            return;
        }
        this.mConnection = new CustomTabsServiceConnection(){

            public void onServiceDisconnected(ComponentName componentName) {
                Logger.debug("CustomTabsService is disconnected", new Object[0]);
                this.setClient(null);
            }

            public void onCustomTabsServiceConnected(ComponentName componentName, CustomTabsClient customTabsClient) {
                Logger.debug("CustomTabsService is connected", new Object[0]);
                customTabsClient.warmup(0L);
                this.setClient(customTabsClient);
            }

            private void setClient(@Nullable CustomTabsClient client) {
                CustomTabManager.this.mClient.set(client);
                CustomTabManager.this.mClientLatch.countDown();
            }
        };
        if (!CustomTabsClient.bindCustomTabsService((Context)this.mContext, (String)browserPackage, (CustomTabsServiceConnection)this.mConnection)) {
            Logger.info("Unable to bind custom tabs service", new Object[0]);
            this.mClientLatch.countDown();
        }
    }

    public CustomTabsIntent.Builder createCustomTabsIntentBuilder() {
        return new CustomTabsIntent.Builder(this.createSession());
    }

    public synchronized void unbind() {
        if (this.mConnection == null) {
            return;
        }
        this.mContext.unbindService((ServiceConnection)this.mConnection);
        this.mClient.set(null);
        Logger.debug("CustomTabsService is disconnected", new Object[0]);
    }

    private CustomTabsSession createSession() {
        try {
            this.mClientLatch.await(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Logger.info("Interrupted while waiting for browser connection", new Object[0]);
            this.mClientLatch.countDown();
        }
        CustomTabsClient client = this.mClient.get();
        if (client != null) {
            return client.newSession(null);
        }
        return null;
    }
}

