/*
 * Decompiled with CFR 0.152.
 */
package net.openid.appauth;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import java.util.Collection;

public final class Preconditions {
    public static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    public static <T> T checkNotNull(T reference, @Nullable Object errorMessage) {
        if (reference == null) {
            throw new NullPointerException(String.valueOf(errorMessage));
        }
        return reference;
    }

    @NonNull
    public static String checkNotEmpty(String str, @Nullable Object errorMessage) {
        Preconditions.checkNotNull(str, errorMessage);
        Preconditions.checkArgument(!TextUtils.isEmpty((CharSequence)str), errorMessage);
        return str;
    }

    @NonNull
    public static <T extends Collection<?>> T checkCollectionNotEmpty(T collection, @Nullable Object errorMessage) {
        Preconditions.checkNotNull(collection, errorMessage);
        Preconditions.checkArgument(!collection.isEmpty(), errorMessage);
        return collection;
    }

    @NonNull
    public static String checkNullOrNotEmpty(String str, @Nullable Object errorMessage) {
        if (str != null) {
            Preconditions.checkNotEmpty(str, errorMessage);
        }
        return str;
    }

    public static void checkArgument(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean expression, @Nullable Object errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
    }

    public static void checkArgument(boolean expression, @NonNull String errorTemplate, Object ... params) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(errorTemplate, params));
        }
    }
}

