/*
 * Decompiled with CFR 0.152.
 */
package net.openid.appauth;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.openid.appauth.AdditionalParamsProcessor;
import net.openid.appauth.Clock;
import net.openid.appauth.JsonUtil;
import net.openid.appauth.Preconditions;
import net.openid.appauth.RegistrationRequest;
import net.openid.appauth.SystemClock;
import org.json.JSONException;
import org.json.JSONObject;

public class RegistrationResponse {
    static final String PARAM_CLIENT_ID = "client_id";
    static final String PARAM_CLIENT_SECRET = "client_secret";
    static final String PARAM_CLIENT_SECRET_EXPIRES_AT = "client_secret_expires_at";
    static final String PARAM_REGISTRATION_ACCESS_TOKEN = "registration_access_token";
    static final String PARAM_REGISTRATION_CLIENT_URI = "registration_client_uri";
    static final String PARAM_CLIENT_ID_ISSUED_AT = "client_id_issued_at";
    static final String PARAM_TOKEN_ENDPOINT_AUTH_METHOD = "token_endpoint_auth_method";
    static final String KEY_REQUEST = "request";
    static final String KEY_ADDITIONAL_PARAMETERS = "additionalParameters";
    private static final Set<String> BUILT_IN_PARAMS = new HashSet<String>(Arrays.asList("client_id", "client_secret", "client_secret_expires_at", "registration_access_token", "registration_client_uri", "client_id_issued_at", "token_endpoint_auth_method"));
    @NonNull
    public final RegistrationRequest request;
    @NonNull
    public final String clientId;
    @Nullable
    public final Long clientIdIssuedAt;
    @Nullable
    public final String clientSecret;
    @Nullable
    public final Long clientSecretExpiresAt;
    @Nullable
    public final String registrationAccessToken;
    @Nullable
    public final Uri registrationClientUri;
    @Nullable
    public final String tokenEndpointAuthMethod;
    @NonNull
    public final Map<String, String> additionalParameters;

    private RegistrationResponse(@NonNull RegistrationRequest request, @NonNull String clientId, @Nullable Long clientIdIssuedAt, @Nullable String clientSecret, @Nullable Long clientSecretExpiresAt, @Nullable String registrationAccessToken, @Nullable Uri registrationClientUri, @Nullable String tokenEndpointAuthMethod, @NonNull Map<String, String> additionalParameters) {
        this.request = request;
        this.clientId = clientId;
        this.clientIdIssuedAt = clientIdIssuedAt;
        this.clientSecret = clientSecret;
        this.clientSecretExpiresAt = clientSecretExpiresAt;
        this.registrationAccessToken = registrationAccessToken;
        this.registrationClientUri = registrationClientUri;
        this.tokenEndpointAuthMethod = tokenEndpointAuthMethod;
        this.additionalParameters = additionalParameters;
    }

    @NonNull
    public static RegistrationResponse fromJson(@NonNull RegistrationRequest request, @NonNull String jsonStr) throws JSONException, MissingArgumentException {
        Preconditions.checkNotEmpty(jsonStr, "jsonStr cannot be null or empty");
        return RegistrationResponse.fromJson(request, new JSONObject(jsonStr));
    }

    @NonNull
    public static RegistrationResponse fromJson(@NonNull RegistrationRequest request, @NonNull JSONObject json) throws JSONException, MissingArgumentException {
        Preconditions.checkNotNull(request, "registration request cannot be null");
        return new Builder(request).fromResponseJson(json).build();
    }

    @NonNull
    public JSONObject jsonSerialize() {
        JSONObject json = new JSONObject();
        JsonUtil.put(json, KEY_REQUEST, this.request.jsonSerialize());
        JsonUtil.put(json, PARAM_CLIENT_ID, this.clientId);
        JsonUtil.putIfNotNull(json, PARAM_CLIENT_ID_ISSUED_AT, this.clientIdIssuedAt);
        JsonUtil.putIfNotNull(json, PARAM_CLIENT_SECRET, this.clientSecret);
        JsonUtil.putIfNotNull(json, PARAM_CLIENT_SECRET_EXPIRES_AT, this.clientSecretExpiresAt);
        JsonUtil.putIfNotNull(json, PARAM_REGISTRATION_ACCESS_TOKEN, this.registrationAccessToken);
        JsonUtil.putIfNotNull(json, PARAM_REGISTRATION_CLIENT_URI, this.registrationClientUri);
        JsonUtil.putIfNotNull(json, PARAM_TOKEN_ENDPOINT_AUTH_METHOD, this.tokenEndpointAuthMethod);
        JsonUtil.put(json, KEY_ADDITIONAL_PARAMETERS, JsonUtil.mapToJsonObject(this.additionalParameters));
        return json;
    }

    @NonNull
    public String jsonSerializeString() {
        return this.jsonSerialize().toString();
    }

    public static RegistrationResponse jsonDeserialize(@NonNull JSONObject json) throws JSONException {
        Preconditions.checkNotNull(json, "json cannot be null");
        if (!json.has(KEY_REQUEST)) {
            throw new IllegalArgumentException("registration request not found in JSON");
        }
        try {
            return new Builder(RegistrationRequest.jsonDeserialize(json.getJSONObject(KEY_REQUEST))).fromResponseJson(json).build();
        }
        catch (MissingArgumentException e) {
            throw new JSONException("missing required field: " + e.getMissingField());
        }
    }

    @NonNull
    public static RegistrationResponse jsonDeserialize(@NonNull String jsonStr) throws JSONException {
        Preconditions.checkNotEmpty(jsonStr, "jsonStr cannot be null or empty");
        return RegistrationResponse.jsonDeserialize(new JSONObject(jsonStr));
    }

    public boolean hasClientSecretExpired() {
        return this.hasClientSecretExpired(SystemClock.INSTANCE);
    }

    @VisibleForTesting
    boolean hasClientSecretExpired(@NonNull Clock clock) {
        Long now = TimeUnit.MILLISECONDS.toSeconds(Preconditions.checkNotNull(clock).getCurrentTimeMillis());
        return this.clientSecretExpiresAt != null && now > this.clientSecretExpiresAt;
    }

    public static final class Builder {
        @NonNull
        private RegistrationRequest mRequest;
        @NonNull
        private String mClientId;
        @Nullable
        private Long mClientIdIssuedAt;
        @Nullable
        private String mClientSecret;
        @Nullable
        private Long mClientSecretExpiresAt;
        @Nullable
        private String mRegistrationAccessToken;
        @Nullable
        private Uri mRegistrationClientUri;
        @Nullable
        private String mTokenEndpointAuthMethod;
        @NonNull
        private Map<String, String> mAdditionalParameters = Collections.emptyMap();

        public Builder(@NonNull RegistrationRequest request) {
            this.setRequest(request);
        }

        @NonNull
        public Builder setRequest(@NonNull RegistrationRequest request) {
            this.mRequest = Preconditions.checkNotNull(request, "request cannot be null");
            return this;
        }

        public Builder setClientId(@NonNull String clientId) {
            Preconditions.checkNotEmpty(clientId, "client ID cannot be null or empty");
            this.mClientId = clientId;
            return this;
        }

        public Builder setClientIdIssuedAt(@Nullable Long clientIdIssuedAt) {
            this.mClientIdIssuedAt = clientIdIssuedAt;
            return this;
        }

        public Builder setClientSecret(@Nullable String clientSecret) {
            this.mClientSecret = clientSecret;
            return this;
        }

        public Builder setClientSecretExpiresAt(@Nullable Long clientSecretExpiresAt) {
            this.mClientSecretExpiresAt = clientSecretExpiresAt;
            return this;
        }

        public Builder setRegistrationAccessToken(@Nullable String registrationAccessToken) {
            this.mRegistrationAccessToken = registrationAccessToken;
            return this;
        }

        public Builder setTokenEndpointAuthMethod(@Nullable String tokenEndpointAuthMethod) {
            this.mTokenEndpointAuthMethod = tokenEndpointAuthMethod;
            return this;
        }

        public Builder setRegistrationClientUri(@Nullable Uri registrationClientUri) {
            this.mRegistrationClientUri = registrationClientUri;
            return this;
        }

        public Builder setAdditionalParameters(Map<String, String> additionalParameters) {
            this.mAdditionalParameters = AdditionalParamsProcessor.checkAdditionalParams(additionalParameters, BUILT_IN_PARAMS);
            return this;
        }

        public RegistrationResponse build() {
            return new RegistrationResponse(this.mRequest, this.mClientId, this.mClientIdIssuedAt, this.mClientSecret, this.mClientSecretExpiresAt, this.mRegistrationAccessToken, this.mRegistrationClientUri, this.mTokenEndpointAuthMethod, this.mAdditionalParameters);
        }

        @NonNull
        public Builder fromResponseJsonString(@NonNull String jsonStr) throws JSONException, MissingArgumentException {
            Preconditions.checkNotEmpty(jsonStr, "json cannot be null or empty");
            return this.fromResponseJson(new JSONObject(jsonStr));
        }

        @NonNull
        public Builder fromResponseJson(@NonNull JSONObject json) throws JSONException, MissingArgumentException {
            this.setClientId(JsonUtil.getString(json, RegistrationResponse.PARAM_CLIENT_ID));
            this.setClientIdIssuedAt(JsonUtil.getLongIfDefined(json, RegistrationResponse.PARAM_CLIENT_ID_ISSUED_AT));
            if (json.has(RegistrationResponse.PARAM_CLIENT_SECRET)) {
                if (!json.has(RegistrationResponse.PARAM_CLIENT_SECRET_EXPIRES_AT)) {
                    throw new MissingArgumentException(RegistrationResponse.PARAM_CLIENT_SECRET_EXPIRES_AT);
                }
                this.setClientSecret(json.getString(RegistrationResponse.PARAM_CLIENT_SECRET));
                this.setClientSecretExpiresAt(json.getLong(RegistrationResponse.PARAM_CLIENT_SECRET_EXPIRES_AT));
            }
            if (json.has(RegistrationResponse.PARAM_REGISTRATION_ACCESS_TOKEN) != json.has(RegistrationResponse.PARAM_REGISTRATION_CLIENT_URI)) {
                String missingParameter = json.has(RegistrationResponse.PARAM_REGISTRATION_ACCESS_TOKEN) ? RegistrationResponse.PARAM_REGISTRATION_CLIENT_URI : RegistrationResponse.PARAM_REGISTRATION_ACCESS_TOKEN;
                throw new MissingArgumentException(missingParameter);
            }
            this.setRegistrationAccessToken(JsonUtil.getStringIfDefined(json, RegistrationResponse.PARAM_REGISTRATION_ACCESS_TOKEN));
            this.setRegistrationClientUri(JsonUtil.getUriIfDefined(json, RegistrationResponse.PARAM_REGISTRATION_CLIENT_URI));
            this.setTokenEndpointAuthMethod(JsonUtil.getStringIfDefined(json, RegistrationResponse.PARAM_TOKEN_ENDPOINT_AUTH_METHOD));
            this.setAdditionalParameters(AdditionalParamsProcessor.extractAdditionalParams(json, (Set<String>)BUILT_IN_PARAMS));
            return this;
        }
    }

    public static class MissingArgumentException
    extends Exception {
        private String mMissingField;

        public MissingArgumentException(String field) {
            super("Missing mandatory registration field: " + field);
            this.mMissingField = field;
        }

        public String getMissingField() {
            return this.mMissingField;
        }
    }
}

