/*
 * Decompiled with CFR 0.152.
 */
package net.openid.appauth;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Map;
import net.openid.appauth.Logger;

class UriUtil {
    private UriUtil() {
    }

    public static Uri parseUriIfAvailable(@Nullable String uri) {
        if (uri == null) {
            return null;
        }
        return Uri.parse((String)uri);
    }

    public static void appendQueryParameterIfNotNull(@NonNull Uri.Builder uriBuilder, @NonNull String paramName, @Nullable Object value) {
        if (value == null) {
            return;
        }
        String valueStr = value.toString();
        if (valueStr == null) {
            return;
        }
        uriBuilder.appendQueryParameter(paramName, value.toString());
    }

    public static Long getLongQueryParameter(@NonNull Uri uri, @NonNull String param) {
        String valueStr = uri.getQueryParameter(param);
        if (valueStr != null) {
            return Long.parseLong(valueStr);
        }
        return null;
    }

    public static String formUrlEncode(Map<String, String> parameters) {
        if (parameters == null) {
            return "";
        }
        ArrayList<String> queryParts = new ArrayList<String>();
        for (Map.Entry<String, String> param : parameters.entrySet()) {
            try {
                queryParts.add(param.getKey() + "=" + URLEncoder.encode(param.getValue(), "utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                Logger.error("Could not utf-8 encode.", new Object[0]);
            }
        }
        return TextUtils.join((CharSequence)"&", queryParts);
    }
}

