/*
 * Decompiled with CFR 0.152.
 */
package net.openid.appauth;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.VisibleForTesting;
import net.openid.appauth.AuthorizationException;
import net.openid.appauth.AuthorizationManagementRequest;
import net.openid.appauth.AuthorizationManagementResponse;
import net.openid.appauth.AuthorizationManagementUtil;
import net.openid.appauth.internal.Logger;
import org.json.JSONException;

public class AuthorizationManagementActivity
extends Activity {
    @VisibleForTesting
    static final String KEY_AUTH_INTENT = "authIntent";
    @VisibleForTesting
    static final String KEY_AUTH_REQUEST = "authRequest";
    @VisibleForTesting
    static final String KEY_COMPLETE_INTENT = "completeIntent";
    @VisibleForTesting
    static final String KEY_CANCEL_INTENT = "cancelIntent";
    @VisibleForTesting
    static final String KEY_AUTHORIZATION_STARTED = "authStarted";
    private boolean mAuthorizationStarted = false;
    private Intent mAuthIntent;
    private AuthorizationManagementRequest mAuthRequest;
    private PendingIntent mCompleteIntent;
    private PendingIntent mCancelIntent;

    public static Intent createStartIntent(Context context, AuthorizationManagementRequest request, Intent authIntent, PendingIntent completeIntent, PendingIntent cancelIntent) {
        Intent intent = AuthorizationManagementActivity.createBaseIntent(context);
        intent.putExtra(KEY_AUTH_INTENT, (Parcelable)authIntent);
        intent.putExtra(KEY_AUTH_REQUEST, request.jsonSerializeString());
        intent.putExtra(KEY_COMPLETE_INTENT, (Parcelable)completeIntent);
        intent.putExtra(KEY_CANCEL_INTENT, (Parcelable)cancelIntent);
        return intent;
    }

    public static Intent createStartForResultIntent(Context context, AuthorizationManagementRequest request, Intent authIntent) {
        return AuthorizationManagementActivity.createStartIntent(context, request, authIntent, null, null);
    }

    public static Intent createResponseHandlingIntent(Context context, Uri responseUri) {
        Intent intent = AuthorizationManagementActivity.createBaseIntent(context);
        intent.setData(responseUri);
        intent.addFlags(0x24000000);
        return intent;
    }

    private static Intent createBaseIntent(Context context) {
        return new Intent(context, AuthorizationManagementActivity.class);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState == null) {
            this.extractState(this.getIntent().getExtras());
        } else {
            this.extractState(savedInstanceState);
        }
    }

    protected void onResume() {
        super.onResume();
        if (!this.mAuthorizationStarted) {
            this.startActivity(this.mAuthIntent);
            this.mAuthorizationStarted = true;
            return;
        }
        if (this.getIntent().getData() != null) {
            this.handleAuthorizationComplete();
        } else {
            this.handleAuthorizationCanceled();
        }
        this.finish();
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.setIntent(intent);
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean(KEY_AUTHORIZATION_STARTED, this.mAuthorizationStarted);
        outState.putParcelable(KEY_AUTH_INTENT, (Parcelable)this.mAuthIntent);
        outState.putString(KEY_AUTH_REQUEST, this.mAuthRequest.jsonSerializeString());
        outState.putParcelable(KEY_COMPLETE_INTENT, (Parcelable)this.mCompleteIntent);
        outState.putParcelable(KEY_CANCEL_INTENT, (Parcelable)this.mCancelIntent);
    }

    private void handleAuthorizationComplete() {
        Uri responseUri = this.getIntent().getData();
        Intent responseData = this.extractResponseData(responseUri);
        if (responseData == null) {
            Logger.error("Failed to extract OAuth2 response from redirect", new Object[0]);
            return;
        }
        responseData.setData(responseUri);
        this.sendResult(this.mCompleteIntent, responseData, -1);
    }

    private void handleAuthorizationCanceled() {
        Logger.debug("Authorization flow canceled by user", new Object[0]);
        Intent cancelData = AuthorizationException.fromTemplate(AuthorizationException.GeneralErrors.USER_CANCELED_AUTH_FLOW, null).toIntent();
        this.sendResult(this.mCancelIntent, cancelData, 0);
    }

    private void extractState(Bundle state) {
        if (state == null) {
            Logger.warn("No stored state - unable to handle response", new Object[0]);
            this.finish();
            return;
        }
        this.mAuthIntent = (Intent)state.getParcelable(KEY_AUTH_INTENT);
        this.mAuthorizationStarted = state.getBoolean(KEY_AUTHORIZATION_STARTED, false);
        this.mCompleteIntent = (PendingIntent)state.getParcelable(KEY_COMPLETE_INTENT);
        this.mCancelIntent = (PendingIntent)state.getParcelable(KEY_CANCEL_INTENT);
        try {
            String authRequestJson = state.getString(KEY_AUTH_REQUEST, null);
            this.mAuthRequest = authRequestJson != null ? AuthorizationManagementUtil.requestFrom(authRequestJson) : null;
        }
        catch (JSONException ex) {
            this.sendResult(this.mCancelIntent, AuthorizationException.AuthorizationRequestErrors.INVALID_REQUEST.toIntent(), 0);
        }
    }

    private void sendResult(PendingIntent callback, Intent cancelData, int resultCode) {
        if (callback != null) {
            try {
                callback.send((Context)this, 0, cancelData);
            }
            catch (PendingIntent.CanceledException e) {
                Logger.error("Failed to send cancel intent", new Object[]{e});
            }
        } else {
            this.setResult(resultCode, cancelData);
        }
    }

    private Intent extractResponseData(Uri responseUri) {
        if (responseUri.getQueryParameterNames().contains("error")) {
            return AuthorizationException.fromOAuthRedirect(responseUri).toIntent();
        }
        AuthorizationManagementResponse response = AuthorizationManagementUtil.responseWith(this.mAuthRequest, responseUri);
        if (this.mAuthRequest.getState() == null && response.getState() != null || this.mAuthRequest.getState() != null && !this.mAuthRequest.getState().equals(response.getState())) {
            Logger.warn("State returned in authorization response (%s) does not match state from request (%s) - discarding response", response.getState(), this.mAuthRequest.getState());
            return AuthorizationException.AuthorizationRequestErrors.STATE_MISMATCH.toIntent();
        }
        return response.toIntent();
    }
}

