/*
 * Decompiled with CFR 0.152.
 */
package net.openid.appauth;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import net.openid.appauth.AuthorizationManagementRequest;
import net.openid.appauth.AuthorizationManagementResponse;
import net.openid.appauth.AuthorizationRequest;
import net.openid.appauth.AuthorizationResponse;
import net.openid.appauth.EndSessionRequest;
import net.openid.appauth.EndSessionResponse;
import net.openid.appauth.Preconditions;
import org.json.JSONException;
import org.json.JSONObject;

class AuthorizationManagementUtil {
    AuthorizationManagementUtil() {
    }

    static AuthorizationManagementRequest requestFrom(String jsonStr) throws JSONException {
        Preconditions.checkNotNull(jsonStr, "jsonStr can not be null");
        JSONObject json = new JSONObject(jsonStr);
        if (AuthorizationRequest.isAuthorizationRequest(json)) {
            return AuthorizationRequest.jsonDeserialize(json);
        }
        if (EndSessionRequest.isEndSessionRequest(json)) {
            return EndSessionRequest.jsonDeserialize(json);
        }
        throw new IllegalArgumentException("No AuthorizationManagementRequest found matching to this json schema");
    }

    @SuppressLint(value={"VisibleForTests"})
    static AuthorizationManagementResponse responseWith(AuthorizationManagementRequest request, Uri uri) {
        if (request instanceof AuthorizationRequest) {
            return new AuthorizationResponse.Builder((AuthorizationRequest)request).fromUri(uri).build();
        }
        if (request instanceof EndSessionRequest) {
            return new EndSessionResponse.Builder((EndSessionRequest)request).fromUri(uri).build();
        }
        throw new IllegalArgumentException("Malformed request or uri");
    }

    @Nullable
    static AuthorizationManagementResponse responseFrom(@NonNull Intent dataIntent) {
        if (EndSessionResponse.containsEndSessionResponse(dataIntent)) {
            return EndSessionResponse.fromIntent(dataIntent);
        }
        if (AuthorizationResponse.containsAuthorizationResponse(dataIntent)) {
            return AuthorizationResponse.fromIntent(dataIntent);
        }
        throw new IllegalArgumentException("Malformed intent");
    }
}

