/*
 * Decompiled with CFR 0.152.
 */
package net.openid.appauth;

import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.openid.appauth.AdditionalParamsProcessor;
import net.openid.appauth.AsciiStringListUtil;
import net.openid.appauth.AuthorizationManagementRequest;
import net.openid.appauth.AuthorizationServiceConfiguration;
import net.openid.appauth.CodeVerifierUtil;
import net.openid.appauth.JsonUtil;
import net.openid.appauth.Preconditions;
import net.openid.appauth.internal.UriUtil;
import org.json.JSONException;
import org.json.JSONObject;

public class AuthorizationRequest
extends AuthorizationManagementRequest {
    public static final String CODE_CHALLENGE_METHOD_S256 = "S256";
    public static final String CODE_CHALLENGE_METHOD_PLAIN = "plain";
    @VisibleForTesting
    static final String PARAM_CLIENT_ID = "client_id";
    @VisibleForTesting
    static final String PARAM_CODE_CHALLENGE = "code_challenge";
    @VisibleForTesting
    static final String PARAM_CODE_CHALLENGE_METHOD = "code_challenge_method";
    @VisibleForTesting
    static final String PARAM_DISPLAY = "display";
    @VisibleForTesting
    static final String PARAM_LOGIN_HINT = "login_hint";
    @VisibleForTesting
    static final String PARAM_PROMPT = "prompt";
    @VisibleForTesting
    static final String PARAM_REDIRECT_URI = "redirect_uri";
    @VisibleForTesting
    static final String PARAM_RESPONSE_MODE = "response_mode";
    @VisibleForTesting
    static final String PARAM_RESPONSE_TYPE = "response_type";
    @VisibleForTesting
    static final String PARAM_SCOPE = "scope";
    @VisibleForTesting
    static final String PARAM_STATE = "state";
    @VisibleForTesting
    static final String PARAM_NONCE = "nonce";
    private static final Set<String> BUILT_IN_PARAMS = AdditionalParamsProcessor.builtInParams("client_id", "code_challenge", "code_challenge_method", "display", "login_hint", "prompt", "redirect_uri", "response_mode", "response_type", "scope", "state");
    private static final String KEY_CONFIGURATION = "configuration";
    private static final String KEY_CLIENT_ID = "clientId";
    private static final String KEY_DISPLAY = "display";
    private static final String KEY_LOGIN_HINT = "login_hint";
    private static final String KEY_PROMPT = "prompt";
    private static final String KEY_RESPONSE_TYPE = "responseType";
    private static final String KEY_REDIRECT_URI = "redirectUri";
    private static final String KEY_SCOPE = "scope";
    private static final String KEY_STATE = "state";
    private static final String KEY_NONCE = "nonce";
    private static final String KEY_CODE_VERIFIER = "codeVerifier";
    private static final String KEY_CODE_VERIFIER_CHALLENGE = "codeVerifierChallenge";
    private static final String KEY_CODE_VERIFIER_CHALLENGE_METHOD = "codeVerifierChallengeMethod";
    private static final String KEY_RESPONSE_MODE = "responseMode";
    private static final String KEY_ADDITIONAL_PARAMETERS = "additionalParameters";
    @NonNull
    public final AuthorizationServiceConfiguration configuration;
    @NonNull
    public final String clientId;
    @Nullable
    public final String display;
    @Nullable
    public final String loginHint;
    @Nullable
    public final String prompt;
    @NonNull
    public final String responseType;
    @NonNull
    public final Uri redirectUri;
    @Nullable
    public final String scope;
    @Nullable
    public final String state;
    @Nullable
    public final String nonce;
    @Nullable
    public final String codeVerifier;
    @Nullable
    public final String codeVerifierChallenge;
    @Nullable
    public final String codeVerifierChallengeMethod;
    @Nullable
    public final String responseMode;
    @NonNull
    public final Map<String, String> additionalParameters;

    private AuthorizationRequest(@NonNull AuthorizationServiceConfiguration configuration, @NonNull String clientId, @NonNull String responseType, @NonNull Uri redirectUri, @Nullable String display, @Nullable String loginHint, @Nullable String prompt, @Nullable String scope, @Nullable String state, @Nullable String nonce, @Nullable String codeVerifier, @Nullable String codeVerifierChallenge, @Nullable String codeVerifierChallengeMethod, @Nullable String responseMode, @NonNull Map<String, String> additionalParameters) {
        this.configuration = configuration;
        this.clientId = clientId;
        this.responseType = responseType;
        this.redirectUri = redirectUri;
        this.additionalParameters = additionalParameters;
        this.display = display;
        this.loginHint = loginHint;
        this.prompt = prompt;
        this.scope = scope;
        this.state = state;
        this.nonce = nonce;
        this.codeVerifier = codeVerifier;
        this.codeVerifierChallenge = codeVerifierChallenge;
        this.codeVerifierChallengeMethod = codeVerifierChallengeMethod;
        this.responseMode = responseMode;
    }

    @Nullable
    public Set<String> getScopeSet() {
        return AsciiStringListUtil.stringToSet(this.scope);
    }

    public Set<String> getPromptValues() {
        return AsciiStringListUtil.stringToSet(this.prompt);
    }

    @Override
    @Nullable
    public String getState() {
        return this.state;
    }

    @Override
    @NonNull
    public Uri toUri() {
        Uri.Builder uriBuilder = this.configuration.authorizationEndpoint.buildUpon().appendQueryParameter(PARAM_REDIRECT_URI, this.redirectUri.toString()).appendQueryParameter(PARAM_CLIENT_ID, this.clientId).appendQueryParameter(PARAM_RESPONSE_TYPE, this.responseType);
        UriUtil.appendQueryParameterIfNotNull(uriBuilder, "display", this.display);
        UriUtil.appendQueryParameterIfNotNull(uriBuilder, "login_hint", this.loginHint);
        UriUtil.appendQueryParameterIfNotNull(uriBuilder, "prompt", this.prompt);
        UriUtil.appendQueryParameterIfNotNull(uriBuilder, "state", this.state);
        UriUtil.appendQueryParameterIfNotNull(uriBuilder, "nonce", this.nonce);
        UriUtil.appendQueryParameterIfNotNull(uriBuilder, "scope", this.scope);
        UriUtil.appendQueryParameterIfNotNull(uriBuilder, PARAM_RESPONSE_MODE, this.responseMode);
        if (this.codeVerifier != null) {
            uriBuilder.appendQueryParameter(PARAM_CODE_CHALLENGE, this.codeVerifierChallenge).appendQueryParameter(PARAM_CODE_CHALLENGE_METHOD, this.codeVerifierChallengeMethod);
        }
        for (Map.Entry<String, String> entry : this.additionalParameters.entrySet()) {
            uriBuilder.appendQueryParameter(entry.getKey(), entry.getValue());
        }
        return uriBuilder.build();
    }

    @Override
    @NonNull
    public JSONObject jsonSerialize() {
        JSONObject json = new JSONObject();
        JsonUtil.put(json, KEY_CONFIGURATION, this.configuration.toJson());
        JsonUtil.put(json, KEY_CLIENT_ID, this.clientId);
        JsonUtil.put(json, KEY_RESPONSE_TYPE, this.responseType);
        JsonUtil.put(json, KEY_REDIRECT_URI, this.redirectUri.toString());
        JsonUtil.putIfNotNull(json, "display", this.display);
        JsonUtil.putIfNotNull(json, "login_hint", this.loginHint);
        JsonUtil.putIfNotNull(json, "scope", this.scope);
        JsonUtil.putIfNotNull(json, "prompt", this.prompt);
        JsonUtil.putIfNotNull(json, "state", this.state);
        JsonUtil.putIfNotNull(json, "nonce", this.nonce);
        JsonUtil.putIfNotNull(json, KEY_CODE_VERIFIER, this.codeVerifier);
        JsonUtil.putIfNotNull(json, KEY_CODE_VERIFIER_CHALLENGE, this.codeVerifierChallenge);
        JsonUtil.putIfNotNull(json, KEY_CODE_VERIFIER_CHALLENGE_METHOD, this.codeVerifierChallengeMethod);
        JsonUtil.putIfNotNull(json, KEY_RESPONSE_MODE, this.responseMode);
        JsonUtil.put(json, KEY_ADDITIONAL_PARAMETERS, JsonUtil.mapToJsonObject(this.additionalParameters));
        return json;
    }

    @NonNull
    public static AuthorizationRequest jsonDeserialize(@NonNull JSONObject json) throws JSONException {
        Preconditions.checkNotNull(json, "json cannot be null");
        Builder builder = new Builder(AuthorizationServiceConfiguration.fromJson(json.getJSONObject(KEY_CONFIGURATION)), JsonUtil.getString(json, KEY_CLIENT_ID), JsonUtil.getString(json, KEY_RESPONSE_TYPE), JsonUtil.getUri(json, KEY_REDIRECT_URI)).setDisplay(JsonUtil.getStringIfDefined(json, "display")).setLoginHint(JsonUtil.getStringIfDefined(json, "login_hint")).setPrompt(JsonUtil.getStringIfDefined(json, "prompt")).setState(JsonUtil.getStringIfDefined(json, "state")).setNonce(JsonUtil.getStringIfDefined(json, "nonce")).setCodeVerifier(JsonUtil.getStringIfDefined(json, KEY_CODE_VERIFIER), JsonUtil.getStringIfDefined(json, KEY_CODE_VERIFIER_CHALLENGE), JsonUtil.getStringIfDefined(json, KEY_CODE_VERIFIER_CHALLENGE_METHOD)).setResponseMode(JsonUtil.getStringIfDefined(json, KEY_RESPONSE_MODE)).setAdditionalParameters(JsonUtil.getStringMap(json, KEY_ADDITIONAL_PARAMETERS));
        if (json.has("scope")) {
            builder.setScopes(AsciiStringListUtil.stringToSet(JsonUtil.getString(json, "scope")));
        }
        return builder.build();
    }

    @NonNull
    public static AuthorizationRequest jsonDeserialize(@NonNull String jsonStr) throws JSONException {
        Preconditions.checkNotNull(jsonStr, "json string cannot be null");
        return AuthorizationRequest.jsonDeserialize(new JSONObject(jsonStr));
    }

    static boolean isAuthorizationRequest(JSONObject json) {
        return json.has(KEY_REDIRECT_URI);
    }

    public static final class Builder {
        @NonNull
        private AuthorizationServiceConfiguration mConfiguration;
        @NonNull
        private String mClientId;
        @Nullable
        private String mDisplay;
        @Nullable
        private String mLoginHint;
        @Nullable
        private String mPrompt;
        @NonNull
        private String mResponseType;
        @NonNull
        private Uri mRedirectUri;
        @Nullable
        private String mScope;
        @Nullable
        private String mState;
        @Nullable
        private String mNonce;
        @Nullable
        private String mCodeVerifier;
        @Nullable
        private String mCodeVerifierChallenge;
        @Nullable
        private String mCodeVerifierChallengeMethod;
        @Nullable
        private String mResponseMode;
        @NonNull
        private Map<String, String> mAdditionalParameters = new HashMap<String, String>();

        public Builder(@NonNull AuthorizationServiceConfiguration configuration, @NonNull String clientId, @NonNull String responseType, @NonNull Uri redirectUri) {
            this.setAuthorizationServiceConfiguration(configuration);
            this.setClientId(clientId);
            this.setResponseType(responseType);
            this.setRedirectUri(redirectUri);
            this.setState(AuthorizationManagementRequest.generateRandomState());
            this.setNonce(AuthorizationManagementRequest.generateRandomState());
            this.setCodeVerifier(CodeVerifierUtil.generateRandomCodeVerifier());
        }

        public Builder setAuthorizationServiceConfiguration(@NonNull AuthorizationServiceConfiguration configuration) {
            this.mConfiguration = Preconditions.checkNotNull(configuration, "configuration cannot be null");
            return this;
        }

        @NonNull
        public Builder setClientId(@NonNull String clientId) {
            this.mClientId = Preconditions.checkNotEmpty(clientId, "client ID cannot be null or empty");
            return this;
        }

        public Builder setDisplay(@Nullable String display) {
            this.mDisplay = Preconditions.checkNullOrNotEmpty(display, "display must be null or not empty");
            return this;
        }

        public Builder setLoginHint(@Nullable String loginHint) {
            this.mLoginHint = Preconditions.checkNullOrNotEmpty(loginHint, "login hint must be null or not empty");
            return this;
        }

        @NonNull
        public Builder setPrompt(@Nullable String prompt) {
            this.mPrompt = Preconditions.checkNullOrNotEmpty(prompt, "prompt must be null or non-empty");
            return this;
        }

        @NonNull
        public Builder setPromptValues(String ... promptValues) {
            if (promptValues == null) {
                this.mPrompt = null;
                return this;
            }
            return this.setPromptValues(Arrays.asList(promptValues));
        }

        @NonNull
        public Builder setPromptValues(@Nullable Iterable<String> promptValues) {
            this.mPrompt = AsciiStringListUtil.iterableToString(promptValues);
            return this;
        }

        @NonNull
        public Builder setResponseType(@NonNull String responseType) {
            this.mResponseType = Preconditions.checkNotEmpty(responseType, "expected response type cannot be null or empty");
            return this;
        }

        @NonNull
        public Builder setRedirectUri(@NonNull Uri redirectUri) {
            this.mRedirectUri = Preconditions.checkNotNull(redirectUri, "redirect URI cannot be null or empty");
            return this;
        }

        @NonNull
        public Builder setScope(@Nullable String scope) {
            if (TextUtils.isEmpty((CharSequence)scope)) {
                this.mScope = null;
            } else {
                this.setScopes(scope.split(" +"));
            }
            return this;
        }

        @NonNull
        public Builder setScopes(String ... scopes) {
            if (scopes == null) {
                scopes = new String[]{};
            }
            this.setScopes(Arrays.asList(scopes));
            return this;
        }

        @NonNull
        public Builder setScopes(@Nullable Iterable<String> scopes) {
            this.mScope = AsciiStringListUtil.iterableToString(scopes);
            return this;
        }

        @NonNull
        public Builder setState(@Nullable String state) {
            this.mState = Preconditions.checkNullOrNotEmpty(state, "state cannot be empty if defined");
            return this;
        }

        @NonNull
        public Builder setNonce(@Nullable String nonce) {
            this.mNonce = Preconditions.checkNullOrNotEmpty(nonce, "state cannot be empty if defined");
            return this;
        }

        @NonNull
        public Builder setCodeVerifier(@Nullable String codeVerifier) {
            if (codeVerifier != null) {
                CodeVerifierUtil.checkCodeVerifier(codeVerifier);
                this.mCodeVerifier = codeVerifier;
                this.mCodeVerifierChallenge = CodeVerifierUtil.deriveCodeVerifierChallenge(codeVerifier);
                this.mCodeVerifierChallengeMethod = CodeVerifierUtil.getCodeVerifierChallengeMethod();
            } else {
                this.mCodeVerifier = null;
                this.mCodeVerifierChallenge = null;
                this.mCodeVerifierChallengeMethod = null;
            }
            return this;
        }

        @NonNull
        public Builder setCodeVerifier(@Nullable String codeVerifier, @Nullable String codeVerifierChallenge, @Nullable String codeVerifierChallengeMethod) {
            if (codeVerifier != null) {
                CodeVerifierUtil.checkCodeVerifier(codeVerifier);
                Preconditions.checkNotEmpty(codeVerifierChallenge, "code verifier challenge cannot be null or empty if verifier is set");
                Preconditions.checkNotEmpty(codeVerifierChallengeMethod, "code verifier challenge method cannot be null or empty if verifier is set");
            } else {
                Preconditions.checkArgument(codeVerifierChallenge == null, "code verifier challenge must be null if verifier is null");
                Preconditions.checkArgument(codeVerifierChallengeMethod == null, "code verifier challenge method must be null if verifier is null");
            }
            this.mCodeVerifier = codeVerifier;
            this.mCodeVerifierChallenge = codeVerifierChallenge;
            this.mCodeVerifierChallengeMethod = codeVerifierChallengeMethod;
            return this;
        }

        @NonNull
        public Builder setResponseMode(@Nullable String responseMode) {
            Preconditions.checkNullOrNotEmpty(responseMode, "responseMode must not be empty");
            this.mResponseMode = responseMode;
            return this;
        }

        @NonNull
        public Builder setAdditionalParameters(@Nullable Map<String, String> additionalParameters) {
            this.mAdditionalParameters = AdditionalParamsProcessor.checkAdditionalParams(additionalParameters, BUILT_IN_PARAMS);
            return this;
        }

        @NonNull
        public AuthorizationRequest build() {
            return new AuthorizationRequest(this.mConfiguration, this.mClientId, this.mResponseType, this.mRedirectUri, this.mDisplay, this.mLoginHint, this.mPrompt, this.mScope, this.mState, this.mNonce, this.mCodeVerifier, this.mCodeVerifierChallenge, this.mCodeVerifierChallengeMethod, this.mResponseMode, Collections.unmodifiableMap(new HashMap<String, String>(this.mAdditionalParameters)));
        }
    }

    public static final class ResponseMode {
        public static final String QUERY = "query";
        public static final String FRAGMENT = "fragment";
    }

    public static final class Scope {
        public static final String ADDRESS = "address";
        public static final String EMAIL = "email";
        public static final String OFFLINE_ACCESS = "offline_access";
        public static final String OPENID = "openid";
        public static final String PHONE = "phone";
        public static final String PROFILE = "profile";
    }

    public static final class Prompt {
        public static final String NONE = "none";
        public static final String LOGIN = "login";
        public static final String CONSENT = "consent";
        public static final String SELECT_ACCOUNT = "select_account";
    }

    public static final class Display {
        public static final String PAGE = "page";
        public static final String POPUP = "popup";
        public static final String TOUCH = "touch";
        public static final String WAP = "wap";
    }
}

