/*
 * Decompiled with CFR 0.152.
 */
package net.openid.appauth;

import android.content.Intent;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import net.openid.appauth.AuthorizationManagementResponse;
import net.openid.appauth.EndSessionRequest;
import net.openid.appauth.JsonUtil;
import net.openid.appauth.Preconditions;
import org.json.JSONException;
import org.json.JSONObject;

public class EndSessionResponse
extends AuthorizationManagementResponse {
    public static final String EXTRA_RESPONSE = "net.openid.appauth.EndSessionResponse";
    @VisibleForTesting
    static final String KEY_REQUEST = "request";
    @VisibleForTesting
    static final String KEY_STATE = "state";
    @NonNull
    public final EndSessionRequest request;
    @NonNull
    public final String state;

    private EndSessionResponse(@NonNull EndSessionRequest request, @NonNull String state) {
        this.request = request;
        this.state = state;
    }

    @Override
    @NonNull
    public String getState() {
        return this.state;
    }

    @Override
    @NonNull
    public JSONObject jsonSerialize() {
        JSONObject json = new JSONObject();
        JsonUtil.put(json, KEY_REQUEST, this.request.jsonSerialize());
        JsonUtil.putIfNotNull(json, KEY_STATE, this.state);
        return json;
    }

    @NonNull
    public static EndSessionResponse jsonDeserialize(@NonNull JSONObject json) throws JSONException {
        if (!json.has(KEY_REQUEST)) {
            throw new IllegalArgumentException("authorization request not provided and not found in JSON");
        }
        EndSessionRequest request = EndSessionRequest.jsonDeserialize(json.getJSONObject(KEY_REQUEST));
        return new EndSessionResponse(request, JsonUtil.getString(json, KEY_STATE));
    }

    @NonNull
    public static EndSessionResponse jsonDeserialize(@NonNull String jsonStr) throws JSONException {
        return EndSessionResponse.jsonDeserialize(new JSONObject(jsonStr));
    }

    @Override
    public Intent toIntent() {
        Intent data = new Intent();
        data.putExtra(EXTRA_RESPONSE, this.jsonSerializeString());
        return data;
    }

    @Nullable
    public static EndSessionResponse fromIntent(@NonNull Intent dataIntent) {
        Preconditions.checkNotNull(dataIntent, "dataIntent must not be null");
        if (!dataIntent.hasExtra(EXTRA_RESPONSE)) {
            return null;
        }
        try {
            return EndSessionResponse.jsonDeserialize(dataIntent.getStringExtra(EXTRA_RESPONSE));
        }
        catch (JSONException ex) {
            throw new IllegalArgumentException("Intent contains malformed auth response", ex);
        }
    }

    static boolean containsEndSessionResponse(@NonNull Intent intent) {
        return intent.hasExtra(EXTRA_RESPONSE);
    }

    public static final class Builder {
        @NonNull
        private EndSessionRequest mRequest;
        @NonNull
        private String mState;

        public Builder(@NonNull EndSessionRequest request) {
            this.setRequest(request);
        }

        @VisibleForTesting
        Builder fromUri(@NonNull Uri uri) {
            this.setState(uri.getQueryParameter(EndSessionResponse.KEY_STATE));
            return this;
        }

        public Builder setRequest(@NonNull EndSessionRequest request) {
            this.mRequest = Preconditions.checkNotNull(request, "request cannot be null");
            return this;
        }

        public Builder setState(@NonNull String state) {
            this.mState = Preconditions.checkNotEmpty(state, "state cannot be null or empty");
            return this;
        }

        @NonNull
        public EndSessionResponse build() {
            return new EndSessionResponse(this.mRequest, this.mState);
        }
    }
}

