/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.connection.channel.forwarded;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.connection.Connection;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.channel.OpenFailException;
import net.schmizz.sshj.connection.channel.forwarded.AbstractForwardedChannel;
import net.schmizz.sshj.connection.channel.forwarded.AbstractForwardedChannelOpener;
import net.schmizz.sshj.connection.channel.forwarded.ConnectListener;
import net.schmizz.sshj.transport.TransportException;

public class RemotePortForwarder
extends AbstractForwardedChannelOpener {
    protected static final String PF_REQ = "tcpip-forward";
    protected static final String PF_CANCEL = "cancel-tcpip-forward";
    protected final Map<Forward, ConnectListener> listeners = new ConcurrentHashMap<Forward, ConnectListener>();

    public RemotePortForwarder(Connection conn) {
        super("forwarded-tcpip", conn);
    }

    public Forward bind(Forward forward, ConnectListener listener) throws ConnectionException, TransportException {
        SSHPacket reply = this.req(PF_REQ, forward);
        if (forward.port == 0) {
            try {
                forward.port = reply.readUInt32AsInt();
            }
            catch (Buffer.BufferException e) {
                throw new ConnectionException(e);
            }
        }
        this.log.info("Remote end listening on {}", (Object)forward);
        this.listeners.put(forward, listener);
        return forward;
    }

    public void cancel(Forward forward) throws ConnectionException, TransportException {
        try {
            this.req(PF_CANCEL, forward);
        }
        finally {
            this.listeners.remove(forward);
        }
    }

    protected SSHPacket req(String reqName, Forward forward) throws ConnectionException, TransportException {
        byte[] specifics = ((Buffer.PlainBuffer)((Buffer.PlainBuffer)new Buffer.PlainBuffer().putString(forward.address)).putUInt32(forward.port)).getCompactData();
        return this.conn.sendGlobalRequest(reqName, true, specifics).retrieve(this.conn.getTimeoutMs(), TimeUnit.MILLISECONDS);
    }

    public Set<Forward> getActiveForwards() {
        return this.listeners.keySet();
    }

    @Override
    public void handleOpen(SSHPacket buf) throws ConnectionException, TransportException {
        ForwardedTCPIPChannel chan;
        try {
            chan = new ForwardedTCPIPChannel(this.conn, buf.readUInt32AsInt(), buf.readUInt32(), buf.readUInt32(), new Forward(buf.readString(), buf.readUInt32AsInt()), buf.readString(), buf.readUInt32AsInt());
        }
        catch (Buffer.BufferException be) {
            throw new ConnectionException(be);
        }
        if (this.listeners.containsKey(chan.getParentForward())) {
            this.callListener(this.listeners.get(chan.getParentForward()), chan);
        } else {
            chan.reject(OpenFailException.Reason.ADMINISTRATIVELY_PROHIBITED, "Forwarding was not requested on `" + chan.getParentForward() + "`");
        }
    }

    public static class ForwardedTCPIPChannel
    extends AbstractForwardedChannel {
        public static final String TYPE = "forwarded-tcpip";
        private final Forward fwd;

        public ForwardedTCPIPChannel(Connection conn, int recipient, long remoteWinSize, long remoteMaxPacketSize, Forward fwd, String origIP, int origPort) {
            super(conn, TYPE, recipient, remoteWinSize, remoteMaxPacketSize, origIP, origPort);
            this.fwd = fwd;
        }

        public Forward getParentForward() {
            return this.fwd;
        }
    }

    public static final class Forward {
        private final String address;
        private int port;

        public Forward(int port) {
            this("", port);
        }

        public Forward(String address) {
            this(address, 0);
        }

        public Forward(String address, int port) {
            this.address = address;
            this.port = port;
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Forward other = (Forward)obj;
            return this.address.equals(other.address) && this.port == other.port;
        }

        public String getAddress() {
            return this.address;
        }

        public int getPort() {
            return this.port;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            return this.address + ":" + this.port;
        }
    }
}

