/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.thucydides.core.annotations.Issue;
import net.thucydides.core.annotations.Issues;
import net.thucydides.core.annotations.Pending;
import net.thucydides.core.annotations.Step;
import net.thucydides.core.annotations.Title;
import net.thucydides.core.annotations.Version;
import net.thucydides.core.annotations.WithTag;
import net.thucydides.core.annotations.WithTagValuesOf;
import net.thucydides.core.annotations.WithTags;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.reports.html.Formatter;
import net.thucydides.core.tags.TagConverters;
import net.thucydides.core.util.NameConverter;
import org.apache.commons.lang3.StringUtils;

public class TestAnnotations {
    private final Class<?> testClass;
    private final List<TestTag> NO_TAGS = new ArrayList<TestTag>();

    private TestAnnotations(Class<?> testClass) {
        this.testClass = testClass;
    }

    public static TestAnnotations forClass(Class<?> testClass) {
        return new TestAnnotations(testClass);
    }

    public Optional<String> getAnnotatedTitleForMethod(String methodName) {
        if (this.testClass != null && this.testClassHasMethodCalled(methodName)) {
            return this.getAnnotatedTitle(methodName);
        }
        return Optional.empty();
    }

    public boolean isPending(String methodName) {
        Optional<Method> method = this.getMethodCalled(methodName);
        return method.isPresent() && TestAnnotations.isPending(method.get());
    }

    public static boolean isPending(Method method) {
        return method != null && method.getAnnotation(Pending.class) != null;
    }

    public static boolean isIgnored(Method method) {
        return method != null && TestAnnotations.hasAnnotationCalled(method, "Ignore");
    }

    public static boolean shouldSkipNested(Method method) {
        if (method != null) {
            Step stepAnnotation = method.getAnnotation(Step.class);
            return stepAnnotation != null && !stepAnnotation.callNestedMethods();
        }
        return false;
    }

    private static boolean hasAnnotationCalled(Method method, String annotationName) {
        Annotation[] annotations = method.getAnnotations();
        return Arrays.stream(annotations).anyMatch(annotation -> annotation.annotationType().getSimpleName().equals(annotationName));
    }

    public boolean isIgnored(String methodName) {
        Optional<Method> method = this.getMethodCalled(methodName);
        return method.isPresent() && TestAnnotations.isIgnored(method.get());
    }

    private Optional<String> getAnnotatedTitle(String methodName) {
        Title titleAnnotation;
        Optional<Method> testMethod = this.getMethodCalled(methodName);
        if (testMethod.isPresent() && (titleAnnotation = testMethod.get().getAnnotation(Title.class)) != null) {
            return Optional.of(titleAnnotation.value());
        }
        return Optional.empty();
    }

    private boolean testClassHasMethodCalled(String methodName) {
        return this.getMethodCalled(methodName).isPresent();
    }

    private Optional<Method> getMethodCalled(String methodName) {
        if (this.testClass == null) {
            return Optional.empty();
        }
        String baseMethodName = NameConverter.withNoArguments(methodName);
        try {
            if (baseMethodName == null) {
                return Optional.empty();
            }
            return Optional.ofNullable(this.testClass.getMethod(baseMethodName, new Class[0]));
        }
        catch (NoSuchMethodException e) {
            return Optional.empty();
        }
    }

    List<String> getAnnotatedIssuesForMethodTitle(String methodName) {
        Optional<String> title = this.getAnnotatedTitleForMethod(methodName);
        return title.map(Formatter::issuesIn).orElseGet(() -> Formatter.issuesIn(methodName));
    }

    private Optional<String> getAnnotatedIssue(String methodName) {
        Optional<Method> testMethod = this.getMethodCalled(methodName);
        if (testMethod.isPresent() && testMethod.get().getAnnotation(Issue.class) != null) {
            return Optional.of(testMethod.get().getAnnotation(Issue.class).value());
        }
        return Optional.empty();
    }

    private Optional<String> getAnnotatedVersion(String methodName) {
        Optional<Method> testMethod = this.getMethodCalled(methodName);
        if (testMethod.isPresent() && testMethod.get().getAnnotation(Version.class) != null) {
            return Optional.of(testMethod.get().getAnnotation(Version.class).value());
        }
        return Optional.empty();
    }

    private String[] getAnnotatedIssues(String methodName) {
        Optional<Method> testMethod = this.getMethodCalled(methodName);
        if (testMethod.isPresent() && testMethod.get().getAnnotation(Issues.class) != null) {
            return testMethod.get().getAnnotation(Issues.class).value();
        }
        return new String[0];
    }

    public Optional<String> getAnnotatedIssueForMethod(String methodName) {
        return this.getAnnotatedIssue(methodName);
    }

    public Optional<String> getAnnotatedVersionForMethod(String methodName) {
        return this.getAnnotatedVersion(methodName);
    }

    public String[] getAnnotatedIssuesForMethod(String methodName) {
        return this.getAnnotatedIssues(methodName);
    }

    public String getAnnotatedIssueForTestCase(Class<?> testCase) {
        Issue issueAnnotation = testCase.getAnnotation(Issue.class);
        if (issueAnnotation != null) {
            return issueAnnotation.value();
        }
        return null;
    }

    public String getAnnotatedVersionForTestCase(Class<?> testCase) {
        Version versionAnnotation = testCase.getAnnotation(Version.class);
        if (versionAnnotation != null) {
            return versionAnnotation.value();
        }
        return null;
    }

    public String[] getAnnotatedIssuesForTestCase(Class<?> testCase) {
        Issues issueAnnotation = testCase.getAnnotation(Issues.class);
        if (issueAnnotation != null) {
            return issueAnnotation.value();
        }
        return null;
    }

    List<String> getIssuesForMethod(String methodName) {
        ArrayList<String> issues = new ArrayList<String>();
        if (this.testClass != null) {
            this.addIssuesFromMethod(methodName, issues);
        } else {
            this.addIssuesFromTestScenarioName(methodName, issues);
        }
        return issues;
    }

    private void addIssuesFromTestScenarioName(String methodName, List<String> issues) {
        issues.addAll(this.getAnnotatedIssuesForMethodTitle(methodName));
    }

    private void addIssuesFromMethod(String methodName, List<String> issues) {
        if (this.getAnnotatedIssues(methodName) != null) {
            issues.addAll(Arrays.asList(this.getAnnotatedIssues(methodName)));
        }
        if (this.getAnnotatedIssue(methodName).isPresent()) {
            issues.add(this.getAnnotatedIssue(methodName).get());
        }
        if (this.getAnnotatedTitle(methodName) != null) {
            this.addIssuesFromTestScenarioName(methodName, issues);
        }
    }

    public List<TestTag> getTagsForMethod(String methodName) {
        ArrayList<TestTag> allTags = new ArrayList<TestTag>(this.getTags());
        allTags.addAll(this.getTagsFor(methodName));
        return new ArrayList<TestTag>(allTags);
    }

    public List<TestTag> getTags() {
        return this.getTags(this.testClass);
    }

    private List<TestTag> getTags(Class<?> testClass) {
        ArrayList<TestTag> tags = new ArrayList<TestTag>();
        if (testClass == null) {
            return this.NO_TAGS;
        }
        this.addTagValues(tags, testClass.getAnnotation(WithTagValuesOf.class));
        this.addTags(tags, testClass.getAnnotation(WithTags.class));
        this.addTag(tags, testClass.getAnnotation(WithTag.class));
        if (testClass.getSuperclass() != Object.class) {
            tags.addAll(this.getTags(testClass.getSuperclass()));
        }
        return tags;
    }

    private void addTag(List<TestTag> tags, WithTag tagAnnotation) {
        if (tagAnnotation != null) {
            tags.add(this.convertToTestTag(tagAnnotation));
        }
    }

    private void addTags(List<TestTag> tags, WithTags tagSet) {
        if (tagSet != null) {
            Set newTags = Arrays.stream(tagSet.value()).map(TagConverters::convertToTestTag).collect(Collectors.toSet());
            tags.addAll(newTags);
        }
    }

    private void addTagValues(List<TestTag> tags, WithTagValuesOf tagSet) {
        if (tagSet != null) {
            Set newTags = Arrays.stream(tagSet.value()).map(TestTag::withValue).collect(Collectors.toSet());
            tags.addAll(newTags);
        }
    }

    private List<TestTag> getTagsFor(String methodName) {
        ArrayList<TestTag> tags = new ArrayList<TestTag>();
        Optional<Method> testMethod = this.getMethodCalled(methodName);
        if (testMethod.isPresent()) {
            this.addTagValues(tags, testMethod.get().getAnnotation(WithTagValuesOf.class));
            this.addTags(tags, testMethod.get().getAnnotation(WithTags.class));
            this.addTag(tags, testMethod.get().getAnnotation(WithTag.class));
        }
        return tags;
    }

    private TestTag convertToTestTag(WithTag withTag) {
        if (StringUtils.isEmpty((CharSequence)withTag.value())) {
            return TestTag.withName(withTag.name()).andType(withTag.type());
        }
        return TestTag.withValue(withTag.value());
    }
}

